﻿using System;
using System.Windows.Forms;
using System.Globalization;
using System.Threading;
using System.IO;
using System.Text;
using System.Configuration;
using System.Xml;
using System.Diagnostics;
using System.Runtime.InteropServices;
using System.Data;
using System.Text.RegularExpressions;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;


namespace TextDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        [DllImport("JHScale.dll")]
        private static extern int JHScale_TxDevice_Sim();
        [DllImport("JHScale.dll")]
        private static extern int JHScale_TxDevice(byte[] pIP, byte[] pFileName);

        private void button1_Click(object sender, EventArgs e)
        {
            if(IPinTextButton.Checked)
            {
                //此处写入的文件JHScaleT.txt必须与JHScale.ini中TxFile的描述相同
                //The file to be write must be the same as TxFile in JHScale.ini
                FileStream fs = new FileStream("JHScaleT.txt", FileMode.Create);
                StreamWriter sw = new StreamWriter(fs);
                sw.WriteLine("ZTD\t" + IP_TextBox.Text);
                sw.Write(contentTextBox.Text);
                sw.Flush();
                sw.Close();
                fs.Close();
                int rv = JHScale_TxDevice_Sim();
                if (rv == 0)
                    ;//success
                else if (rv == 1)
                    ;//Connect failed
                else if (rv == 2)
                    ;//File error;
            }
            else if (IPinAPIButton.Checked)
            {
                //You can use all name here.
                //此处可以是任意的文件名，但如果文件名包含中文，则“Encoding.ASCII.”的部分需要做相应修改，以确保中文以dll能识别的编码方式传递。
                string FileName="NewFile.txt";
                FileStream fs = new FileStream(FileName, FileMode.Create);
                StreamWriter sw = new StreamWriter(fs);
                sw.Write(contentTextBox.Text);
                sw.Flush();
                sw.Close();
                fs.Close();
                int rv = JHScale_TxDevice(Encoding.ASCII.GetBytes(IP_TextBox.Text), Encoding.ASCII.GetBytes(FileName));
                if (rv == 0)
                    ;//success
                else if (rv == 1)
                    ;//Connect failed
                else if (rv == 2)
                    ;//File error;
            }
        }
    }
}
