﻿using System;
using System.Collections;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Data;
using System.Collections.Generic;
using System.Security.Cryptography;
using System.Globalization;

namespace JHMA_Console
{
    public partial class MainForm : Form
    {
        volatile private TcpClient tcpConsole = null;
        private byte[] AsyBuf = new byte[1];
        private Encoding gpEnc;
        private StreamReader sr;
        private StreamWriter sw;
        private Queue<string> ReceiveBuf = new Queue<string>();
        private string Identify;

        private class SimComboVD_No
        {
            private string value;

            public string Value
            {
                get { return this.value; }
                set { this.value = value; }
            }
            private string display;

            public string Display
            {
                get { return display; }
                set { display = value; }
            }
        }

        public MainForm()
        {
            InitializeComponent();
        }

        private int ParseInt(string item, int def)
        {
            int res;
            if (!int.TryParse(item, out res)) return def;
            else return res;
        }
        private int ParseInt(string item)
        {
            return ParseInt(item, 0);
        }

        private void MainForm_Load(object sender, EventArgs e)
        {

            string comboName = Application.StartupPath + @"\JHMA_Console.xml";
            try
            {
                uiDataSet.ConsoleTask.ReadXml(comboName);
            }
            catch (Exception exp)
            {
                MessageBox.Show(this, "Need JHMA_Console.xml" + Environment.NewLine + Environment.NewLine + exp.Message,
                    "JHMA.ini Editor", MessageBoxButtons.OK, MessageBoxIcon.Error);
                this.Close();
                return;
            }

            this.Text = Program.GetLang("pw_JHMAConsole");
            Link_GroupBox.Text = Program.GetLang("pw_Link");
            LocalPC_RadioButton.Text = Program.GetLang("pw_LocalPC");
            RemotePC_RadioButton.Text = Program.GetLang("pw_RemotePC");
            NoKey_RadioButton.Text = Program.GetLang("pw_NoSecurity");
            Console_Button.Text = Program.GetLang("pw_StartConsole");

            Command_GroupBox.Text = Program.GetLang("pw_Command");
            GetStatus_Button.Text = Program.GetLang("pw_GetStatus");
            DeviceCon_Button.Text = Program.GetLang("pw_ConnectDevice");
            DeviceDiscon_Button.Text = Program.GetLang("pw_DisconnectDevice");
            DeviceAdd_Button.Text = Program.GetLang("pw_AddDeviceList");
            DeviceRemove_Button.Text = Program.GetLang("pw_RemoveDeviceList");
            RemoveUndone_Button.Text = Program.GetLang("pw_RemoveUndone");
            CloseJHMA_Button.Text = Program.GetLang("pw_CloseJHMA");
            FileTask_GroupBox.Text = Program.GetLang("pw_FileTask");
            RunFileTask_Button.Text = Program.GetLang("pw_RunFileTask");
            ConsoleTask_GroupBox.Text = Program.GetLang("pw_ConsoleTask");
            RunConsoleTask_Button.Text = Program.GetLang("pw_RunConsoleTask");
            ManualSend_Button.Text = Program.GetLang("pw_ManualSend");
            TCP_Send_Label.Text = Program.GetLang("pw_ConsoleSent");
            TCP_Receive_Label.Text = Program.GetLang("pw_ConsoleReceived");

            gpEnc = Encoding.GetEncoding(Program.GetLang("Encoding"));

            UIDataSet.ConsoleTaskRow ctrow = GetCurrentConsoleTask();
            ConsoleTask_Format_TextBox.Text = ctrow.Format;
            ConsoleTask_Format_TextBox.Enabled = (ctrow.Format.Length == 0);
            ConsoleTask_Command_TextBox.Text = ctrow.Command;
            ConsoleTask_Command_TextBox.Enabled = (ctrow.Command.Length == 0);
            ConsoleTask_Content_TextBox.Text = ctrow.Content;
        }

        private UIDataSet.ConsoleTaskRow GetCurrentConsoleTask()
        {
            if (consoleTask_BindingSource.Position == -1)
            {
                return null;
            }
            else if(consoleTask_BindingSource.Current==null)
            {
                return null;
            }
            else
            {
                DataRowView rowView = (DataRowView)consoleTask_BindingSource.Current;
                return (UIDataSet.ConsoleTaskRow)rowView.Row;
            }
        }

        private void ConsoleTask_ComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            UIDataSet.ConsoleTaskRow frow = GetCurrentConsoleTask();
            if ((ConsoleTask_ComboBox.SelectedItem != null) && ((string)ConsoleTask_ComboBox.Text != frow.Name))
            {
                UIDataSet.ConsoleTaskRow ctrow = ((UIDataSet.ConsoleTaskRow)(((System.Data.DataRowView)ConsoleTask_ComboBox.SelectedItem).Row));

                ConsoleTask_Format_TextBox.Text = ctrow.Format;
                ConsoleTask_Format_TextBox.Enabled = (ctrow.Format.Length == 0);
                ConsoleTask_Command_TextBox.Text = ctrow.Command;
                ConsoleTask_Command_TextBox.Enabled = (ctrow.Command.Length == 0);
                ConsoleTask_Content_TextBox.Text = ctrow.Content;
            }
        }


        private void WithKey_RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            WithKey_TextBox.Enabled = WithKey_RadioButton.Checked;
        }
        delegate void TCPRead_Tip_Callback(string Info);
        private void TCPRead_Tip(string Info)
        {
            if(Info=="")
                return;
            if (this.TCP_Receive_TextBox.InvokeRequired)
            {
                this.Invoke(new TCPRead_Tip_Callback(TCPRead_Tip), new object[] { Info });
            }
            else
            {
                string[] v = Info.Split('\t');
                if (v[0] == "ZPS")
                {
                    if (v.Length >= 2)
                    {
                        if (v[1].Length == 0)
                        {
                            if (WithAES)
                            {
                                Info = Info + "\r\n" + "(Error: No AES Checking)";
                                tcpConsole.Close();
                            }
                        }
                        else
                        {
                            if (WithAES)
                                SendLine("ZPS\t" + AES_Decrypt_HexToHex(v[1]) + "\t");
                            else
                                Info = Info + "\r\n" + "(Error: Need AES Checking)";
                        }
                    }
                }
                else if (v[0] == "ZTS")
                {
                    if (v.Length >= 2)
                    {
                        Identify = v[1];
                    }
                }
                else if (v[0] == "ZTT")
                {
                    if ((v.Length >= 2) && (v[1].Length > 2))
                    {
                        if (WithAES)
                        {
                            Info = Info + "\r\n" + "(Parse: ZTT\t" + hexTstring(AES_Decrypt_HexToHex(v[1])) + ")";
                        }
                    }
                }

                string aa = TCP_Receive_TextBox.Text;

                if (aa.Length >= 8192)
                {
                    aa.Substring(aa.IndexOf("\r\n", 2048), 0);
                }

                TCP_Receive_TextBox.Text = aa + Info + "\r\n";
            }
        }
        private void TCPReadCallBack(IAsyncResult ar)
        {
            if (tcpConsole == null)
                return;

            try
            {
                if (!tcpConsole.Connected)
                {
                    return;
                }

                tcpConsole.GetStream().EndRead(ar);

                while (true)
                {
                    if (!tcpConsole.Connected)
                    {
                        return;
                    }
                    try
                    {
                        string line = sr.ReadLine();
                        if (line != null)
                        {
                            TCPRead_Tip(line);
                            ReceiveBuf.Enqueue(line);
                        }
                        else
                            break;
                    }
                    catch (Exception)
                    {
                    }
                }
            }
            catch (Exception)
            {
                ;
            }
            finally
            {
                if (tcpConsole != null)
                {
                    tcpConsole.Close();
                    tcpConsole = null;
                    ConsoleStatus(false);
                }
            }
        }
        bool WithAES = false;
        private void Console_Button_Click(object sender, EventArgs e)
        {
            if (tcpConsole == null)
            {
                IPAddress address;
                IPEndPoint ip;
                try
                {
                    if (LocalPC_RadioButton.Checked)
                    {
                        address = IPAddress.Parse("127.0.0.1");
                    }
                    else
                    {
                        address = IPAddress.Parse(RemotePC_ipTextBox.IpText);
                    }
                    if (WithKey_TextBox.Text.Length < 2)
                        NoKey_RadioButton.Checked = true;
                    if ((WithKey_RadioButton.Checked) && (WithKey_TextBox.Text.Length >= 2))
                    {
                        setKey_AES(WithKey_TextBox.Text);
                        WithAES = true;
                    }
                    else
                        WithAES = false;
                }
                catch
                {
                    return;
                }
                ip = new IPEndPoint(address, (int)RemotePort_NumericUpDown.Value);
                try
                {
                    tcpConsole = new TcpClient();
                    tcpConsole.Connect(ip);
                    tcpConsole.SendTimeout = 5000;
                    tcpConsole.ReceiveTimeout = 0;

                    NetworkStream ns = tcpConsole.GetStream();
                    sr = new StreamReader(ns, gpEnc);
                    sw = new StreamWriter(ns, gpEnc);
                    sw.AutoFlush = true;

                    tcpConsole.GetStream().BeginRead(AsyBuf, 0, 0, new AsyncCallback(TCPReadCallBack), 0);

                    ConsoleStatus(true);
                }
                catch
                {
                    // Connect failed
                    if (tcpConsole != null) tcpConsole.Close();
                    tcpConsole = null;
                    ConsoleStatus(false);
                }
            }
            else
            {
                tcpConsole.Close();
                while (tcpConsole != null) Thread.Sleep(100);
                ConsoleStatus(false);
            }
        }

        delegate void ConsoleStatus_Callback(bool Running);
        private void ConsoleStatus(bool Running)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new ConsoleStatus_Callback(ConsoleStatus), new object[] { Running });
            }
            else
            {
                if (Running)
                {
                    Console_Button.Text = Program.GetLang("pw_EndConsole");
                }
                else
                {
                    Console_Button.Text = Program.GetLang("pw_StartConsole");
                }
                LocalPC_RadioButton.Enabled = RemotePC_RadioButton.Enabled = Key_Panel.Enabled = !Running;

                Command_GroupBox.Enabled = FileTask_GroupBox.Enabled = ConsoleTask_GroupBox.Enabled = mf_SplitContainer.Panel2.Enabled = Running;
            }
        }
        private void SendLine(string line)
        {
            string aa = TCP_Send_TextBox.Text;

            if (aa.Length >= 8192)
            {
                aa.Substring(aa.IndexOf("\r\n", 2048), 0);
            }

            TCP_Send_TextBox.Text = aa + line + "\r\n";
            sw.WriteLine(line);
        }

        private void GetStatus_Button_Click(object sender, EventArgs e)
        {
            SendLine("ZSK\tZTT\t");
        }

        private void ManualSend_Button_Click(object sender, EventArgs e)
        {
            string[] lines = Send_TextBox.Text.Split(new string[] { "\r\n" }, StringSplitOptions.RemoveEmptyEntries);
            for (int loop = 0; loop < lines.Length; loop++)
            {
                SendLine(lines[loop]);
            }
        }

        private void RunFileTask_Button_Click(object sender, EventArgs e)
        {
            SendLine("ZSK\tZFT\t" + ((int)RemotePort_This_NumericUpDown.Value).ToString() + "\t");
        }

        private void RunConsoleTask_Button_Click(object sender, EventArgs e)
        {
            if (ConsoleTask_Content_TextBox.Text.Length == 0)
                return;
            string hextext;
            if (WithAES)
                hextext = AES_Encrypt_StringToHex(ConsoleTask_Content_TextBox.Text);
            else
            {
                StringBuilder sb = new StringBuilder();
                byte[] bInput;
                if (Program.GetLang("Encoding") == "GB2312")
                    bInput = Encoding.GetEncoding("GB2312").GetBytes(ConsoleTask_Content_TextBox.Text);
                else //if(Program.GetLang("Encoding")=="UTF-8")
                    bInput = Encoding.UTF8.GetBytes(ConsoleTask_Content_TextBox.Text);

                for (int loop = 0; loop < bInput.Length; loop++)
                {
                    sb.AppendFormat("{0:x2}", bInput[loop]);
                }
                hextext = sb.ToString();
            }
            SendLine("ZSK\tZDC\t");
            for (int loop = 0; loop < hextext.Length; loop += 128)
            {
                if (hextext.Length - loop > 128)
                {
                    SendLine("ZSK\tZDA\t" + hextext.Substring(loop, 128) + "\t");
                }
                else
                {
                    SendLine("ZSK\tZDA\t" + hextext.Substring(loop) + "\t");
                }
            }
            SendLine("ZSK\tZFT\t0\t" + ConsoleTask_Command_TextBox.Text + "\t" + ConsoleTask_Format_TextBox.Text + "\t");
        }
        private bool needcheckleft = false;
        private void WithKey_TextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\b')
            {
            }
            else if (e.KeyChar == 13)
            {
                ;
            }
            else if (e.KeyChar == 3)//ctrl-c
            {
                ;
            }
            else if (e.KeyChar == 0x16)//ctrl-v
            {
                needcheckleft = true;
            }
            else if (e.KeyChar == 0x18)//ctrl-x
            {
                ;
            }
            else if ((e.KeyChar >= 'a') && (e.KeyChar <= 'f'))
            {
                e.KeyChar = (char)(e.KeyChar + 'A' - 'a');
                if (WithKey_TextBox.Text.Length >= 64)
                    e.KeyChar = '\0';
            }
            else if ((e.KeyChar >= 'A') && (e.KeyChar <= 'F'))
            {
                if (WithKey_TextBox.Text.Length >= 64)
                    e.KeyChar = '\0';
            }
            else if ((e.KeyChar >= '0') && (e.KeyChar <= '9'))
            {
                if (WithKey_TextBox.Text.Length >= 64)
                    e.KeyChar = '\0';
            }
            else
                e.KeyChar = '\0';
        }
        private string LeftHex(string input)
        {
            char[] ic = input.ToUpper().ToCharArray();
            string rvic = "";
            for (int loop = 0; loop < ic.Length; loop++)
            {
                if ((ic[loop] >= '0') && (ic[loop] <= '9'))
                    rvic = rvic + ic[loop];
                else if ((ic[loop] >= 'A') && (ic[loop] <= 'F'))
                    rvic = rvic + ic[loop];
                if (rvic.Length >= 64)
                    break;
            }
            return rvic;
        }
        private void WithKey_TextBox_TextChanged(object sender, EventArgs e)
        {
            if (needcheckleft)
            {
                WithKey_TextBox.Text = LeftHex(WithKey_TextBox.Text);
                needcheckleft = false;
            }
        }

        //Key:0123456789012345.         DDDDDDDDDDDDDDDD->88 47 0B 3B 15 7A EC 89 A6 5A B5 12 98 FB CD 5F 
        //Key:012345678901234567890123. DDDDDDDDDDDDDDDD->AE C0 AA BD E3 84 16 C6 C7 16 3A C5 9E BC 79 5F 

        private byte[] hexTbyte(string Input)
        {
            byte[] bInput = new byte[Input.Length / 2];
            for (int loop = 0; loop < Input.Length / 2; loop++)
                bInput[loop] = byte.Parse(Input.Substring(loop * 2, 2), NumberStyles.HexNumber);
            return bInput;
        }
        private string hexTstring(string Input)
        {
            byte[] bInput = new byte[Input.Length / 2];
            int loop = 0;
            for (; loop < Input.Length / 2; loop++)
            {
                byte ct=byte.Parse(Input.Substring(loop * 2, 2), NumberStyles.HexNumber);
                if (ct!=0)
                    bInput[loop] = ct;
                else
                    break;
            }
            string str;
            if (Program.GetLang("Encoding") == "GB2312")
                str = Encoding.GetEncoding("GB2312").GetString(bInput,0,loop);
            else //if(Program.GetLang("Encoding")=="UTF-8")
                str = Encoding.UTF8.GetString(bInput, 0, loop);
            return str;
        }
        Aes localAES = null;
        private void setKey_AES(string key)
        {
            char[] ic = key.ToUpper().ToCharArray();
            string rvic = "";
            Aes.KeySize aks;
            for (int loop = 0; loop < ic.Length; loop++)
            {
                if ((ic[loop] >= '0') && (ic[loop] <= '9'))
                    rvic = rvic + ic[loop];
                else if ((ic[loop] >= 'A') && (ic[loop] <= 'F'))
                    rvic = rvic + ic[loop];
                if (rvic.Length >= 64)
                    break;
            }
            if (rvic.Length >= 64)
            {
                rvic = rvic.Substring(0, 64);
                aks=Aes.KeySize.Bits256;
            }
            else if (rvic.Length >= 48)
            {
                rvic = rvic.Substring(0, 48);
                aks = Aes.KeySize.Bits192;
            }
            else if (key.Length >= 32)
            {
                rvic = rvic.Substring(0, 32);
                aks = Aes.KeySize.Bits128;
            }
            else
            {
                rvic = (rvic + "00000000000000000000000000000000").Substring(0, 32);
                aks = Aes.KeySize.Bits128;
            }
            byte[] rvbt = hexTbyte(rvic);
            localAES = new Aes(aks, rvbt);
        }
        public string AES_Encrypt_StringToHex(string Input)
        {
            byte[] bInput;
            if (Program.GetLang("Encoding") == "GB2312")
                bInput = Encoding.GetEncoding("GB2312").GetBytes(Input);
            else //if(Program.GetLang("Encoding")=="UTF-8")
                bInput = Encoding.UTF8.GetBytes(Input);
            StringBuilder sb = new StringBuilder();
            for (int loop = 0; loop < bInput.Length; loop += 16)
            {
                byte[] output = new byte[16];
                if (bInput.Length - loop >= 16)
                    localAES.Cipher(bInput, loop, output);
                else
                {
                    byte[] filled_Input = new byte[16] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };
                    Array.Copy(bInput, loop, filled_Input, 0, bInput.Length - loop);
                    localAES.Cipher(filled_Input, 0, output);
                }
                for (int lp2 = 0; lp2 < 16; lp2++)
                    sb.AppendFormat("{0:x2}", output[lp2]);
            }
            return sb.ToString().ToUpper();
        }
        public string AES_Decrypt_HexToHex(string Input)
        {
            byte[] bInput = hexTbyte(Input);
            StringBuilder sb = new StringBuilder();
            for (int loop = 0; loop < bInput.Length/16; loop ++)
            {
                byte[] output = new byte[16];
                localAES.InvCipher(bInput, loop*16, output);
                for (int lp2 = 0; lp2 < 16; lp2++)
                    sb.AppendFormat("{0:x2}", output[lp2]);
            }
            return sb.ToString().ToUpper();
        }

        private void RemotePC_RadioButton_CheckedChanged(object sender, EventArgs e)
        {
            RemotePC_ipTextBox.Enabled = RemotePC_RadioButton.Checked;
        }

        private void TCP_Send_TextBox_TextChanged(object sender, EventArgs e)
        {
            TCP_Send_TextBox.Select(TCP_Send_TextBox.TextLength, 0);
            TCP_Send_TextBox.ScrollToCaret();
        }

        private void TCP_Receive_TextBox_TextChanged(object sender, EventArgs e)
        {
            TCP_Receive_TextBox.Select(TCP_Receive_TextBox.TextLength, 0);
            TCP_Receive_TextBox.ScrollToCaret();
        }

        private void DeviceCon_Button_Click(object sender, EventArgs e)
        {
            using (TargetIPForm form = new TargetIPForm(false))
            {
                if (form.ShowDialog(this) == DialogResult.OK)
                {
                    SendLine("ZSK\tZCN\t" + form.SG_IPP + "\t");
                }
            }
        }

        private void DeviceDiscon_Button_Click(object sender, EventArgs e)
        {
            using (TargetIPForm form = new TargetIPForm(true))
            {
                if (form.ShowDialog(this) == DialogResult.OK)
                {
                    SendLine("ZSK\tZDN\t" + form.SG_IPP + "\t");
                }
            }
        }

        private void DeviceAdd_Button_Click(object sender, EventArgs e)
        {
            using (DeviceListForm form = new DeviceListForm(Identify))
            {
                if (form.ShowDialog(this) == DialogResult.OK)
                {
                    SendLine("ZSK\tZAN\t" + form.SG_ID + "\t");
                }
            }

        }

        private void DeviceRemove_Button_Click(object sender, EventArgs e)
        {
            using (DeviceListForm form = new DeviceListForm(Identify))
            {
                if (form.ShowDialog(this) == DialogResult.OK)
                {
                    SendLine("ZSK\tZBN\t" + form.SG_ID + "\t");
                }
            }
        }

        private void RemoveUndone_Button_Click(object sender, EventArgs e)
        {
            using (DeviceListForm form = new DeviceListForm(Identify))
            {
                if (form.ShowDialog(this) == DialogResult.OK)
                {
                    SendLine("ZSK\tZUN\t" + form.SG_ID + "\t");
                }
            }
        }

        private void CloseJHMA_Button_Click(object sender, EventArgs e)
        {
            SendLine("ZSK\tZQT\t");
        }



    }
}
