/*
 * Decompiled with CFR 0.152.
 */
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSLogManager;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.common.DLSScannerConfig;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Vector;

public class DLSInstallerListener
extends SimpleInstallerListener {
    protected static final String strUsbfs = "usbfs                   /proc/bus/usb           usbfs   noauto,devmode=0666 0 0\n";
    protected static final String strSysInit = "[ -d /proc/bus/usb ] && mount usbfs\n";
    protected DLSLogManager log = DLSLogManager.getInstance();
    protected int numCommPorts = 4;
    protected String strInstallPath;
    protected Vector fileList = new Vector();
    protected AbstractUIProgressHandler handler;
    protected boolean bUpdateClasspath = false;
    protected boolean bUpdateComport = false;
    protected boolean bUpdateUsb = false;
    protected boolean bUpdateLibrarypath = false;

    public DLSInstallerListener() {
        try {
            String str = System.getProperty("os.name");
            str = str.toUpperCase();
            this.log.trace(this, "OS=" + str);
            if (!OsVersion.IS_WINDOWS) {
                str = System.getProperty("user.name");
                this.log.trace(this, "User=" + str);
                if (!str.equals("root")) {
                    System.out.print("\r\nSorry: " + str + ", but setup.jar must be run as root\r\n\r\n");
                    this.log.error(this, "Exiting because of non-root user.");
                    System.exit(1);
                }
            }
            this.log.in(this, "Constructor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.out(this, "Constructor");
    }

    public boolean isFileListener() {
        return true;
    }

    public void beforeFile(File file, PackFile pf) throws Exception {
        if (file != null) {
            this.fileList.add(file);
        }
    }

    public void afterFile(File fileIn, PackFile pf) throws Exception {
        if (fileIn == null) {
            return;
        }
        this.chmod(fileIn.getAbsolutePath(), 666);
        if (pf.getAdditionals() == null) {
            return;
        }
        Object file = pf.getAdditionals().get("chmod.file");
        int fileVal = -1;
        if (file != null && file instanceof Integer) {
            fileVal = (Integer)file;
        }
        this.chmod(fileIn.getAbsolutePath(), fileVal);
    }

    public void afterDir(File dirPath, PackFile pf) throws Exception {
        if (dirPath == null) {
            return;
        }
        this.chmod(dirPath.getAbsolutePath(), 777);
        if (pf.getAdditionals() == null) {
            return;
        }
        Object file = pf.getAdditionals().get("chmod.dir");
        int fileVal = -1;
        if (file != null && file instanceof Integer) {
            fileVal = (Integer)file;
        }
        this.chmod(dirPath.getAbsolutePath(), fileVal);
    }

    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        String str = pack.name;
        if (str != null) {
            if (str.equals("Update CLASSPATH")) {
                this.bUpdateClasspath = true;
            } else if (str.equals("Update COM port Access")) {
                this.bUpdateComport = true;
            } else if (str.equals("Update USB Access")) {
                this.bUpdateUsb = true;
            } else if (str.equals("Update LD_LIBRARY_PATH")) {
                this.bUpdateLibrarypath = true;
            }
        }
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        this.log.in(this, "afterPacks, installPath= " + idata.getInstallPath());
        this.strInstallPath = idata.getInstallPath();
        this.handler = handler;
        if (this.bUpdateUsb) {
            this.updateFSTab();
        }
        if (this.bUpdateComport) {
            this.updateLocal();
        }
        if (this.bUpdateClasspath) {
            this.updateClassPath();
        }
        if (this.bUpdateLibrarypath) {
            this.updateLibraryPath();
        }
        if (OsVersion.IS_WINDOWS) {
            handler.emitNotification("A system reboot is required for changes to take effect.");
        } else {
            handler.emitNotification("A Logoff and Logon is required for changes to take effect.");
        }
        String[] params = new String[]{"ln", "-s", this.strInstallPath + "/SupportJars/libJavaxUsb-1.0.0.so", this.strInstallPath + "/SupportJars/libJavaxUsb.so"};
        String[] output = new String[2];
        FileExecutor fe = new FileExecutor();
        fe.executeCommand(params, output);
        String[] fixfiles = new String[]{"fixfiles", "restore", this.strInstallPath + "/SupportJars/libJavaxUsb-1.0.0.so"};
        fe.executeCommand(fixfiles, output);
        this.log.out(this, "afterPacks");
    }

    protected void updateFSTab() {
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        this.log.in(this, "updateFSTab");
        this.updateSysInit();
        FileExecutor fe = new FileExecutor();
        String[] output = new String[2];
        if (this.findAndReplace("/etc/fstab", "usbfs", strUsbfs, false)) {
            String[] umount = new String[]{"umount", "usbfs"};
            fe.executeCommand(umount, output);
            String[] mount = new String[]{"mount", "usbfs"};
            fe.executeCommand(mount, output);
        } else {
            String[] umount2 = new String[]{"umount", "/proc/bus/usb"};
            fe.executeCommand(umount2, output);
            String[] mount2 = new String[]{"mount", "-n", "-t", "usbfs", "-o", "devmode=0666", "/proc/bus/usb", "/proc/bus/usb"};
            fe.executeCommand(mount2, output);
        }
        this.chmod("/etc/fstab", 644);
        this.log.out(this, "updateFSTab");
    }

    protected void updateLocal() {
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        this.log.in(this, "updateLocal");
        File f = new File("/etc/rc.d/boot.local");
        String strFilename = f.exists() ? "/etc/rc.d/boot.local" : "/etc/rc.d/rc.local";
        for (int i = 0; i < this.numCommPorts; ++i) {
            String strFind = "stty --file=/dev/ttyS" + Integer.toString(i) + " raw";
            String strReplace = strFind + "\n";
            this.findAndReplace(strFilename, strFind, strReplace, true);
            String[] params = new String[]{"stty", "--file=/dev/ttyS" + Integer.toString(i), "raw"};
            FileExecutor fe = new FileExecutor();
            String[] output = new String[2];
            fe.executeCommand(params, output);
            strFind = "chmod a+rw /dev/ttyS" + Integer.toString(i);
            strReplace = strFind + "\n";
            this.findAndReplace(strFilename, strFind, strReplace, true);
            this.chmod("/dev/ttyS" + Integer.toString(i), 666);
        }
        this.chmod(strFilename, 755);
        this.log.out(this, "updateLocal");
    }

    protected void updateSysInit() {
        String str;
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        this.log.in(this, "updateSysInit");
        String strFilename = "/etc/rc.d/rc.sysinit";
        Vector<String> v = new Vector<String>();
        try {
            FileInputStream fis = new FileInputStream(strFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            str = br.readLine();
            while (str != null) {
                if (str.indexOf("mount -n -t usbfs") >= 0 && str.indexOf("devmode=0666") < 0) {
                    v.add(str);
                }
                str = br.readLine();
            }
        }
        catch (NullPointerException npe) {
            this.log.error(this, "NullPointerException: " + npe.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            this.log.error(this, "FileNotFoundException: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.log.error(this, "IOExcepiton: " + ioe.getMessage());
        }
        int pos = 0;
        Iterator it = v.iterator();
        while (it.hasNext()) {
            str = (String)it.next();
            pos = str.indexOf("mount -n -t usbfs");
            if (pos < 0) continue;
            try {
                String strTmp = str.substring(0, pos + 18) + "-o devmode=0666 " + str.substring(pos + 18) + "\n";
                this.findAndReplace(strFilename, str, strTmp, false);
            }
            catch (Exception e) {
                this.log.error(this, "Exception in updateSysInit: " + e.getMessage());
            }
        }
        this.chmod("/etc/rc.d/rc.sysinit", 755);
        this.log.out(this, "updateSysInit");
    }

    protected void addHexClassPath(String strFilename, String strEnv, String strHexValue) {
        this.log.in(this, "addHexClassPath");
        try {
            Vector<String> list = new Vector<String>();
            String str = "";
            FileInputStream fis = new FileInputStream(strFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            str = br.readLine();
            while (str != null) {
                list.add(str);
                str = br.readLine();
            }
            br.close();
            fis.close();
            File delFile = new File(strFilename);
            delFile.delete();
            FileOutputStream fos = new FileOutputStream(strFilename);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            Iterator it = list.iterator();
            while (it.hasNext()) {
                str = (String)it.next();
                String strTmp = str.toUpperCase();
                int pos = 12;
                if (strTmp.indexOf("\"" + strEnv + "\"") == 0) {
                    while (it.hasNext() && str.charAt(str.length() - 1) == '\\') {
                        str = (String)it.next();
                    }
                    bw.write("\"" + strEnv + "\"=");
                    for (int i = 0; i < strHexValue.length(); ++i) {
                        bw.write(strHexValue.charAt(i));
                        if (++pos <= 78 || strHexValue.charAt(i) != ',') continue;
                        pos = 2;
                        bw.write("\\\n  ");
                    }
                    bw.write("\n");
                    continue;
                }
                bw.write(str + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            this.log.error(this, "Error in addHexClassPath:" + e.getMessage());
        }
        this.log.out(this, "addHexClassPath");
    }

    protected void updateWindowsPath(String strEnv, String strDLSEnv, String strPath) {
        this.log.in(this, "updateWindowsPath");
        try {
            int i;
            boolean bFound = false;
            int pos = 0;
            String strClassPathReg = "c:\\ClassPath.reg";
            String strHex = "";
            String[] params = new String[]{"regedit", "/E:A", strClassPathReg, "\"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\""};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            FileInputStream fis = new FileInputStream(strClassPathReg);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String strIn = br.readLine();
            while (strIn != null) {
                String str = strIn.toUpperCase();
                if (str.indexOf("\"" + strEnv + "\"=") == 0) {
                    this.log.trace(this, "Found PATH in: " + strIn);
                    pos = strIn.indexOf("=");
                    strHex = strIn.substring(pos + 1);
                    if (strHex.indexOf("hex(2):") != 0) {
                        byte[] bIn = strHex.getBytes();
                        int prvCh = 32;
                        strHex = "hex(2):";
                        for (i = 1; i < bIn.length - 1; ++i) {
                            if (prvCh != 92 || bIn[i] != 92) {
                                strHex = strHex + Integer.toHexString(bIn[i]) + (bIn.length == i - 1 ? "" : ",");
                            }
                            prvCh = (char)bIn[i];
                        }
                        strHex = strHex + "00";
                    }
                    bFound = true;
                    this.log.trace(this, "Found PATH out: " + strIn);
                    break;
                }
                String strTmp = strIn = br.readLine();
                while (strTmp != null && strTmp.length() != 0 && strTmp.charAt(strTmp.length() - 1) == '\\') {
                    strTmp = br.readLine();
                    if (strTmp == null || strTmp.length() == 0) continue;
                    strIn = strIn.substring(0, strIn.length() - 1);
                    strIn = strIn + strTmp.trim();
                }
            }
            br.close();
            fis.close();
            String strHexDLSEnv = "";
            for (int i2 = 0; i2 < strDLSEnv.length(); ++i2) {
                strHexDLSEnv = strHexDLSEnv + Integer.toHexString(strDLSEnv.charAt(i2)) + ",";
            }
            if (bFound) {
                if (strHex.indexOf(strHexDLSEnv) < 0) {
                    String[] bytes = strHex.split(",");
                    strHex = "";
                    for (i = 0; i < bytes.length && !bytes[i].equals("00"); ++i) {
                        strHex = strHex + bytes[i] + ",";
                    }
                    strHex = strHex + "3b,25," + strHexDLSEnv + "25,00";
                    this.addHexClassPath(strClassPathReg, strEnv, strHex);
                }
            } else {
                this.findAndReplace(strClassPathReg, "\"" + strEnv + "\"=", "\"" + strEnv + "\"=hex(2):25," + strHexDLSEnv + "25,00\n", true);
            }
            byte[] buf = strPath.getBytes();
            strPath = "";
            for (i = 0; i < buf.length; ++i) {
                strPath = buf[i] == 92 ? strPath + "\\\\" : strPath + (char)buf[i];
            }
            this.findAndReplace(strClassPathReg, "\"" + strDLSEnv + "\"=", "\"" + strDLSEnv + "\"=" + "\"" + strPath + "\"\n", true);
            String[] params2 = new String[]{"regedit", "/s", strClassPathReg};
            fe.executeCommand(params2, output);
        }
        catch (FileNotFoundException fnfe) {
            this.log.error(this, "updateWindowsPath error: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.log.error(this, "updateWindowsPath error: " + ioe.getMessage());
        }
        this.log.out(this, "updateWindowsPath");
    }

    protected void updateClassPath() {
        String strFSep;
        String strSep;
        if (OsVersion.IS_WINDOWS) {
            strSep = ";";
            strFSep = "\\";
        } else {
            strSep = ":";
            strFSep = "/";
        }
        String strPath = null;
        String strTemp = null;
        String strClassPath = "." + strSep + this.strInstallPath + strSep + this.strInstallPath + strFSep + "SupportJars" + strSep;
        String strEnvPath = this.strInstallPath + strSep + this.strInstallPath + strFSep + "SupportJars" + strSep;
        this.log.in(this, "updateClassPath");
        Iterator it = this.fileList.iterator();
        String strSave = "";
        while (it.hasNext()) {
            File element = (File)it.next();
            strPath = element.getAbsolutePath();
            if (strPath == null || (strTemp = strPath.toUpperCase()).indexOf(".JAR") <= 0) continue;
            if (strTemp.indexOf("LINUX_COMM") > 0) {
                strSave = strPath + strSep;
                continue;
            }
            strClassPath = strClassPath + strPath + strSep;
        }
        if (OsVersion.IS_WINDOWS) {
            this.updateWindowsPath("CLASSPATH", "DLS_CLASSPATH", strClassPath);
            this.updateWindowsPath("PATH", "DLS_PATH", strEnvPath);
        } else {
            this.chmod("/etc/profile", 644);
        }
        this.log.out(this, "updateClassPath");
    }

    protected void updateLibraryPath() {
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        String strSep = ":";
        String strFSep = "/";
        this.log.in(this, "updateLibraryPath");
        String strSoPath = this.strInstallPath + strFSep + "SupportJars";
        this.findAndReplace("/etc/profile", "DLS_LD_LIBRARY_PATH=", "DLS_LD_LIBRARY_PATH=" + strSoPath + "\n", true);
        this.findAndReplace("/etc/profile", "LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$DLS_LD_LIBRARY_PATH", "LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$DLS_LD_LIBRARY_PATH\n", true);
        this.findAndReplace("/etc/profile", "export LD_LIBRARY_PATH", "export LD_LIBRARY_PATH\n", true);
        this.chmod("/etc/profile", 644);
        this.log.out(this, "updateLibraryPath");
    }

    protected boolean findAndReplace(String strFilename, String strFind, String strReplace, boolean bWriteIfNotFound) {
        this.log.in(this, "findAndReplace: " + strFilename + ", " + strFind + ", " + strReplace);
        boolean bFound = false;
        File f = new File(strFilename);
        if (!f.exists()) {
            this.log.out(this, "findAndReplace: File not found: " + strFilename);
            return bFound;
        }
        String strTempExtension = "dls";
        String strBakExtension = "bak";
        try {
            File newFile = null;
            String str = "";
            File oldFile = new File(strFilename + "." + strTempExtension);
            oldFile.delete();
            oldFile = new File(strFilename + "." + strBakExtension);
            oldFile.delete();
            FileOutputStream fos = new FileOutputStream(strFilename + "." + strTempExtension);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            FileInputStream fis = new FileInputStream(strFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            try {
                str = br.readLine();
                while (str != null) {
                    if (str.indexOf(strFind) == 0) {
                        bFound = true;
                        bw.write(strReplace);
                    } else {
                        bw.write(str + "\n");
                    }
                    str = br.readLine();
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            if (!bFound && bWriteIfNotFound) {
                bw.write(strReplace);
                bFound = true;
            }
            bw.close();
            br.close();
            if (bFound) {
                oldFile = new File(strFilename);
                newFile = new File(strFilename + "." + strBakExtension);
                oldFile.renameTo(newFile);
                oldFile = new File(strFilename + "." + strTempExtension);
                newFile = new File(strFilename);
                oldFile.renameTo(newFile);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.log.error(this, "Error in findAndReplace: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.log.error(this, "Error in findAndReplace: " + ioe.getMessage());
        }
        this.log.out(this, "findAndReplace");
        return bFound;
    }

    protected void setCommonScaleDi(DLSDeviceInfo dlsDeviceInfo) {
        dlsDeviceInfo.setServiceInstanceFactoryClass("com.dls.jpos.service.DLSScaleInstanceFactory");
        dlsDeviceInfo.setServiceClass("com.dls.jpos.service.DLSScaleService");
        dlsDeviceInfo.setVendorName("Datalogic Inc.");
        dlsDeviceInfo.setVendorURL("http://www.datalogic.com");
        dlsDeviceInfo.setDeviceCategory("Scale");
        dlsDeviceInfo.setJposVersion("1.13");
        dlsDeviceInfo.setProductName("ScaleService");
        dlsDeviceInfo.setProductDescription("ScaleService");
        dlsDeviceInfo.setProductURL("http://www.datalogic.com");
        dlsDeviceInfo.setDeviceBus("USB");
    }

    protected void setCommonScannerDi(DLSDeviceInfo dlsDeviceInfo) {
        dlsDeviceInfo.setServiceInstanceFactoryClass("com.dls.jpos.service.DLSScannerInstanceFactory");
        dlsDeviceInfo.setServiceClass("com.dls.jpos.service.DLSScannerService");
        dlsDeviceInfo.setVendorName("Datalogic Inc.");
        dlsDeviceInfo.setVendorURL("http://www.datalogic.com");
        dlsDeviceInfo.setDeviceCategory("Scanner");
        dlsDeviceInfo.setJposVersion("1.13");
        dlsDeviceInfo.setProductName("ScannerService");
        dlsDeviceInfo.setProductDescription("ScannerService");
        dlsDeviceInfo.setProductURL("http://www.datalogic.com");
        dlsDeviceInfo.setDeviceBus("USB");
    }

    protected void updateJavaPosRegistry() {
        this.log.in(this, "updateJavaPosRegistry");
        DLSScaleConfig dlsScaleCfg = new DLSScaleConfig();
        DLSScannerConfig dlsScannerCfg = new DLSScannerConfig();
        DLSDeviceInfo dlsDeviceInfo = new DLSDeviceInfo();
        if (!dlsDeviceInfo.loadConfiguration("defaultScanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(4354);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(18944);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-1000i-USB-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(5633);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(18944);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-2500-USB-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(513);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(19200);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-6000-USB-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(18690);
            dlsDeviceInfo.setVendorId(1203);
            dlsDeviceInfo.setUsage(19200);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-6500-USB-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(514);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(19200);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-8400-USB-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(5377);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(18944);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-Magellan-USB-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(257);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(18944);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-Duet-USB-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(18690);
            dlsDeviceInfo.setVendorId(1203);
            dlsDeviceInfo.setUsage(19200);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-2500-RS232-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setDeviceBus("RS232");
            dlsDeviceInfo.setPort(1);
            dlsDeviceInfo.setBaud(9600);
            dlsDeviceInfo.setDatabits(8);
            dlsDeviceInfo.setParity("None");
            dlsDeviceInfo.setStopbits(1);
            dlsDeviceInfo.setSingleCable(false);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-6000-RS232-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setDeviceBus("RS232");
            dlsDeviceInfo.setPort(1);
            dlsDeviceInfo.setBaud(9600);
            dlsDeviceInfo.setDatabits(8);
            dlsDeviceInfo.setParity("None");
            dlsDeviceInfo.setStopbits(1);
            dlsDeviceInfo.setSingleCable(false);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-6500-RS232-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setDeviceBus("RS232");
            dlsDeviceInfo.setPort(1);
            dlsDeviceInfo.setBaud(9600);
            dlsDeviceInfo.setDatabits(8);
            dlsDeviceInfo.setParity("None");
            dlsDeviceInfo.setStopbits(1);
            dlsDeviceInfo.setSingleCable(false);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-Magellan-RS232-Scanner")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setDeviceBus("RS232");
            dlsDeviceInfo.setPort(1);
            dlsDeviceInfo.setBaud(9600);
            dlsDeviceInfo.setDatabits(8);
            dlsDeviceInfo.setParity("None");
            dlsDeviceInfo.setStopbits(1);
            dlsDeviceInfo.setSingleCable(false);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsScannerCfg.setCanAcceptStatisticsCmd(true);
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-Magellan-RS232-Scanner-SingleCable")) {
            this.setCommonScannerDi(dlsDeviceInfo);
            dlsDeviceInfo.setDeviceBus("RS232");
            dlsDeviceInfo.setPort(3);
            dlsDeviceInfo.setBaud(9600);
            dlsDeviceInfo.setDatabits(7);
            dlsDeviceInfo.setParity("Odd");
            dlsDeviceInfo.setStopbits(1);
            dlsDeviceInfo.setSingleCable(true);
            dlsScannerCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScannerCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-Magellan-USB-Scale")) {
            this.setCommonScaleDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(257);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(28160);
            dlsScaleCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScaleCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("defaultScale")) {
            this.setCommonScaleDi(dlsDeviceInfo);
            dlsDeviceInfo.setProductId(257);
            dlsDeviceInfo.setVendorId(1529);
            dlsDeviceInfo.setUsage(28160);
            dlsScaleCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScaleCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-Magellan-RS232-Scale")) {
            this.setCommonScaleDi(dlsDeviceInfo);
            dlsDeviceInfo.setDeviceBus("RS232");
            dlsDeviceInfo.setPort(2);
            dlsDeviceInfo.setBaud(9600);
            dlsDeviceInfo.setDatabits(7);
            dlsDeviceInfo.setParity("Even");
            dlsDeviceInfo.setStopbits(1);
            dlsDeviceInfo.setSingleCable(false);
            dlsScaleCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScaleCfg.saveConfiguration();
        }
        if (!dlsDeviceInfo.loadConfiguration("DLS-Magellan-RS232-Scale-SingleCable")) {
            this.setCommonScaleDi(dlsDeviceInfo);
            dlsDeviceInfo.setDeviceBus("RS232");
            dlsDeviceInfo.setPort(3);
            dlsDeviceInfo.setBaud(9600);
            dlsDeviceInfo.setDatabits(7);
            dlsDeviceInfo.setParity("Odd");
            dlsDeviceInfo.setStopbits(1);
            dlsDeviceInfo.setSingleCable(true);
            dlsScaleCfg.loadConfiguration(dlsDeviceInfo.getLogicalName());
            dlsDeviceInfo.saveConfiguration();
            dlsScaleCfg.saveConfiguration();
        }
        File oldFile = new File("jpos.xml");
        File newFile = new File(this.strInstallPath + File.separatorChar + "jpos.xml");
        oldFile.renameTo(newFile);
        this.chmod(newFile.getAbsolutePath(), 666);
        this.log.out(this, "updateJavaPosRegistry");
    }

    protected void chmod(String strPath, int permissions) {
        if (OsVersion.IS_WINDOWS || strPath == null) {
            return;
        }
        try {
            File path = new File(strPath);
            if (!path.exists()) {
                return;
            }
            String permStr = Integer.toString(permissions);
            String[] params = new String[]{"chmod", permStr, path.getAbsolutePath()};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
        }
        catch (Exception ioe) {
            this.log.error(this, "chmod error for: " + strPath + "," + permissions + "," + ioe.getMessage());
        }
    }

    public void setInstalldata(AutomatedInstallData data) {
        data.info.setAppVersion("1.13.00");
    }
}

