/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.interpretation.DLSScanner;
import java.util.Hashtable;
import java.util.Iterator;

public class DLS8xxxScanner
extends DLSScanner
implements DLSJposConst {
    protected int CMD_POS = 0;
    protected static final String enableCmd = "E";
    protected static final String disableCmd = "D";
    protected static final String resetCmd = "R";
    protected static final String idRequestCmd = "i";
    protected static final String healthRequestCmd = "h";
    protected static final String statisticsCmd = "s";
    protected static final String infoCmd = "#+OWI0\r\n";
    protected static final String joinCmd = "\r\r$+RN0$-\r";
    protected int nWaitingOnEot = 0;
    protected byte[] sohBuf;
    protected final Object objWaitSohBuf = new Object();
    protected boolean bFirmware = false;
    boolean bBatteryInfo = false;
    protected final Object objWaitAck = new Object();
    public int returnType = 0;
    public int returnQty = 1;
    public Hashtable hTable;

    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    protected int sendMsg(byte[] buf) {
        return this.port.sendData(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMsg(String msg) {
        Object object = this.objWaitSohBuf;
        synchronized (object) {
            this.sohBuf = null;
            int bytesRead = this.sendMsg(msg);
            try {
                this.objWaitSohBuf.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        return this.sohBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRecord(String sRecord) {
        this.log.in(this, "sendRecord");
        Object object = this.objWaitAck;
        synchronized (object) {
            this.bFirmware = true;
            this.nResponse = 255;
            this.sendMsg(sRecord);
            try {
                this.objWaitAck.wait(this.nRecordTimeout);
            }
            catch (InterruptedException ie) {
                this.log.trace(this, "Interrupt exception " + ie);
            }
        }
        this.log.out(this, "sendRecord: " + this.nResponse);
        return this.nResponse;
    }

    public void enable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(enableCmd);
    }

    public void disable() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(disableCmd);
    }

    public void reset() throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        this.sendMsg(resetCmd);
    }

    public void enableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
    }

    public void disableBeep() {
        if (this.log.getFWBusy()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelfTest() {
        if (this.log.getFWBusy()) {
            return;
        }
        this.bAlive = true;
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.sohBuf = null;
                this.sendMsg(statisticsCmd);
                try {
                    this.objWaitSohBuf.wait(this.nTimeout);
                    if (this.sohBuf == null) {
                        this.bAlive = false;
                        this.fireDeviceErrorEvent(-116);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean doHealthCheck() throws DLSException {
        if (this.log.getFWBusy()) {
            return true;
        }
        boolean bRc = true;
        byte[] buf = this.sendReceiveMsg(healthRequestCmd);
        if (buf != null) {
            this.logHealthCheck(buf);
        } else {
            this.log.error(this, "Timeout on HealthCheck");
            bRc = false;
        }
        return bRc;
    }

    public boolean isAlive() {
        if (this.log.getFWBusy()) {
            return this.bAlive;
        }
        this.doSelfTest();
        return this.bAlive;
    }

    public int sendJoin() {
        int sentBytes = this.sendMsg(joinCmd);
        return sentBytes;
    }

    public int sendReset() {
        String outBuf = "#+PROG\r";
        int sentBytes = this.sendMsg(outBuf);
        return sentBytes;
    }

    public void setFirmwareBaudRate() {
        this.log.in(this, "setFirmwareBaudRate");
        this.log.out(this, "setFirmwareBaudRate");
    }

    public void restoreBaudRate() {
        this.log.in(this, "restoreBaudRate");
        this.log.out(this, "restoreBaudRate");
    }

    public void updateConfiguration() {
        this.log.in(this, "updateConfiguration");
        this.log.out(this, "updateConfiguration");
    }

    public DLSScannerConfig reportConfiguration() {
        this.log.in(this, "reportConfiguration");
        this.log.out(this, "reportConfiguration");
        return this.scannerConfig;
    }

    public void directIO(int command, int[] data, Object object) throws DLSException {
        if (this.log.getFWBusy()) {
            return;
        }
        String strResult = "Invalid Command";
        String sendStr = new String();
        switch (command) {
            case 320: {
                String sDispOne = (String)object;
                this.sendMsg("@" + sDispOne + "\r");
                strResult = "Single Line";
                break;
            }
            case 334: {
                Object[] inObject = (Object[])object;
                String[] inStringArray = (String[])inObject;
                this.sendMsg("@" + inStringArray[0] + inStringArray[1] + "\r");
                strResult = "Double Line";
                break;
            }
            case 332: {
                data[0] = this.returnType;
                break;
            }
            case 331: {
                data[0] = this.returnQty;
                this.returnQty = 1;
                break;
            }
            case 333: {
                byte[] outBuf = (byte[])object;
                int sentBytes = this.sendMsg(outBuf);
                strResult = "Display Data";
                break;
            }
            case 335: {
                data[0] = this.returnType;
                strResult = "Return Data";
                break;
            }
            case 336: {
                this.sendMsg(infoCmd);
                strResult = "Return Battery Data";
            }
        }
    }

    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    public Hashtable getStatistics() throws DLSException {
        String put;
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (this.log.getFWBusy()) {
            return table;
        }
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            String strInfoString;
            String[] strInfo = null;
            String str = null;
            String truncated = null;
            String truncated2 = null;
            int i = 0;
            byte[] buf = this.sendReceiveMsg(idRequestCmd);
            if (buf != null && buf.length != 0) {
                strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0003");
                block20: for (i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    truncated = str.replaceAll("\\p{Cntrl}", "");
                    truncated2 = truncated.replaceAll("Sp<", "");
                    if (truncated2.length() <= 1) continue;
                    switch (truncated2.charAt(0)) {
                        case 'r': {
                            put = table.put(DLS_HH_RADIO_VERSION, truncated2.substring(1));
                            continue block20;
                        }
                        case 'A': {
                            put = table.put(DLS_HH_RADIO_APP_VERSION, truncated2.substring(1));
                            continue block20;
                        }
                        case 'M': {
                            put = table.put(DLS_S_MODEL_NAME, truncated2.substring(1));
                            continue block20;
                        }
                        case 'S': {
                            put = table.put(DLS_S_SCANNER_BOARD_SERIAL, truncated2.substring(1));
                            continue block20;
                        }
                        case 'X': {
                            put = table.put(DLS_HH_MODEL_NAME, truncated2.substring(1));
                            continue block20;
                        }
                        case 'Y': {
                            put = table.put(DLS_HH_BASE_SERIAL_NUMBER, truncated2.substring(1));
                            continue block20;
                        }
                        case 'Z': {
                            put = table.put(DLS_HH_BASE_APP_VERSION, truncated2.substring(1));
                        }
                    }
                }
            }
            if ((buf = this.sendReceiveMsg(statisticsCmd)) != null && buf.length != 0) {
                strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0003");
                block21: for (i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    truncated = str.replaceAll("\\p{Cntrl}", "");
                    truncated2 = truncated.replaceAll("Sp<", "");
                    if (truncated2.length() <= 1) continue;
                    switch (truncated2.charAt(0)) {
                        case 'B': {
                            put = table.put(DLS_HH_BATTERY_CHG_CYCLES, truncated2.substring(1));
                            continue block21;
                        }
                        case 'T': {
                            put = table.put(DLS_HH_TRIGGER_PULLS, truncated2.substring(1));
                            continue block21;
                        }
                        case 'K': {
                            put = table.put(DLS_HH_KEY_PRESSES, truncated2.substring(1));
                            continue block21;
                        }
                        case 'l': {
                            put = table.put(DLS_HH_LASER_ON_TIME, truncated2.substring(1));
                            continue block21;
                        }
                        case 'L': {
                            put = table.put(DLS_S_GOOD_SCAN_COUNT, truncated2.substring(1));
                            continue block21;
                        }
                        case 'p': {
                            put = table.put(DLS_HH_BASE_HOURS_POWERED_COUNT, truncated2.substring(1));
                        }
                    }
                }
            }
            if ((buf = this.sendReceiveMsg(healthRequestCmd)) != null && buf.length != 0) {
                strInfoString = new String(buf);
                strInfo = strInfoString.split("\u0003");
                for (i = 0; i < strInfo.length; ++i) {
                    str = strInfo[i];
                    truncated = str.replaceAll("\\p{Cntrl}", "");
                    truncated2 = truncated.replaceAll("Sp<", "");
                    if (truncated2.length() <= 1) continue;
                    switch (truncated2.charAt(0)) {
                        case 'r': {
                            put = table.put(DLS_HH_RADIO_HEALTH, truncated2.substring(1));
                        }
                    }
                }
            }
        }
        put = table.put(DLS_S_DEVICE_CATEGORY, "Scanner");
        put = table.put(DLS_S_INTERFACE, "RS232");
        this.hTable = table;
        return table;
    }

    public Hashtable returnStatistics() throws DLSException {
        return this.hTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataReceived(byte[] inBuf, int inLen) {
        if (this.bFirmware) {
            this.log.in(this, "onDataReceived");
            Object object = this.objWaitAck;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                this.log.out(this, "onDataReceived:" + this.nResponse);
                this.objWaitAck.notify();
                return;
            }
        }
        String value = new String(inBuf);
        if (this.bBatteryInfo) {
            this.log.log(this, "onDataReceived battery stats: \n" + value);
        }
        this.log.log(this, "onDataReceived:" + value);
        if (this.bs.size() == 0 && inBuf[0] == 1 || this.nWaitingOnEot > 0) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                ++this.nWaitingOnEot;
                this.parseMessages(inBuf, (byte)4);
                if (this.msgList.size() > 0) {
                    this.nWaitingOnEot = 0;
                    this.sohBuf = (byte[])this.msgList.get(0);
                    this.msgList.clear();
                    this.objWaitSohBuf.notifyAll();
                } else if (this.nWaitingOnEot > 30) {
                    this.nWaitingOnEot = 0;
                    this.bs.reset();
                    this.msgList.clear();
                }
            }
            return;
        }
        this.parseMessages(inBuf, this.deviceInfo.getRxTrailer());
        Iterator it = this.msgList.iterator();
        byte[] tmpBuf = new byte[255];
        while (it.hasNext()) {
            tmpBuf = (byte[])it.next();
            byte pre = this.deviceInfo.getRxPrefix();
            if (tmpBuf.length <= 2) continue;
            if (pre == tmpBuf[0]) {
                this.CMD_POS = 1;
            }
            int nType = this.extractLocalBarcodeType(tmpBuf[this.CMD_POS], tmpBuf[this.CMD_POS + 1]);
            byte[] barcode = this.extractLocalBarcodeLabel(tmpBuf, 0);
            String str = new String(inBuf);
            String[] pieces = str.split("%");
            if (pieces[2].contains("Q1.2")) {
                try {
                    this.returnQty = Integer.parseInt(pieces[1].substring(1));
                }
                catch (Exception e) {
                    this.returnQty = 0;
                }
            } else {
                this.returnQty = 0;
            }
            switch (barcode[barcode.length - 1]) {
                case 86: {
                    this.returnType = 1;
                    break;
                }
                case 75: {
                    this.returnType = 2;
                    break;
                }
                case 69: {
                    this.returnType = 3;
                    str = "ESC";
                    tmpBuf = str.getBytes();
                    pieces = str.split("");
                    break;
                }
                case 73: {
                    this.returnType = 4;
                    str = "INQ";
                    tmpBuf = str.getBytes();
                    pieces = str.split("");
                    break;
                }
                case 79: {
                    this.returnType = 5;
                    break;
                }
            }
            DLSProperties options = DLSProperties.getInstance();
            this.bSendCookedData = options.get("com.dls.jpos.service.ScannerService.sendCookedData", false);
            if (this.bSendCookedData) {
                tmpBuf = pieces[0].getBytes();
            }
            nType = this.returnType;
            String strTmpBuf = new String(tmpBuf);
            this.log.log(this, "onDataReceived2:" + strTmpBuf);
            if (pieces != null) {
                this.fireLabelReceivedEvent(tmpBuf, pieces[0].getBytes(), nType);
            } else if (strTmpBuf.contains("INQ") || strTmpBuf.contains("ESC")) {
                this.fireLabelReceivedEvent(tmpBuf, tmpBuf, nType);
            } else {
                this.fireLabelReceivedEvent(tmpBuf, null, nType);
            }
            tmpBuf = null;
            pieces = null;
            inBuf = null;
        }
        this.msgList.clear();
    }

    private int extractLocalBarcodeType(byte b1, byte b2) {
        int nType = 0;
        switch (b1) {
            case 73: {
                nType = 106;
                break;
            }
            case 72: {
                nType = 105;
                break;
            }
            case 66: {
                nType = 103;
                break;
            }
            case 65: {
                nType = 104;
                break;
            }
            case 67: {
                nType = 102;
                break;
            }
            case 77: {
                nType = 108;
                break;
            }
            case 78: {
                nType = 107;
                break;
            }
            case 80: {
                nType = 120;
                break;
            }
            case 75: {
                nType = 110;
                break;
            }
            case 76: {
                nType = 109;
                break;
            }
            case 69: {
                nType = 131;
                break;
            }
            case 79: {
                nType = 501;
            }
        }
        return nType;
    }

    private byte[] extractLocalBarcodeLabel(byte[] inBuf, int offset) {
        int start = 1;
        switch (inBuf[offset]) {
            case 66: {
                start = 2;
                break;
            }
            case 82: {
                start = 2;
                break;
            }
            case 70: {
                start = inBuf[offset + 1] == 70 ? 2 : 1;
            }
        }
        byte[] buf = new byte[inBuf.length - 1 - (start + offset)];
        int j = 0;
        for (int i = start + offset; i < inBuf.length - 1; ++i) {
            buf[j++] = inBuf[i];
        }
        return buf;
    }
}

