/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSLogManager;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSRegistry;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.interpretation.DLSDevice;
import com.dls.jpos.interpretation.DeviceErrorStatusListener;
import com.dls.jpos.interpretation.DirectIODataListener;
import com.dls.jpos.service.WMIService;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DirectIOEvent;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;

public class DLSBaseService
implements BaseService,
JposConst,
DeviceErrorStatusListener,
DirectIODataListener,
DLSJposConst {
    protected DLSLogManager log = DLSLogManager.getInstance();
    protected DLSDevice device = null;
    protected EventCallbacks evtCallback = null;
    protected String strLogicalName = null;
    public final int deviceServiceVersion = 1013044;
    protected String manufacturerName;
    private boolean firstTime = true;
    public boolean bEnabled = false;
    public boolean beenClaimed = false;
    protected boolean bFreezeEvents = false;
    protected int deviceState = 1;
    protected boolean bClaimed = false;
    protected String strCheckHealthText = "";
    protected int nMaxWeight = 30000;
    protected int nWeightUnit = 0;
    protected boolean bMetricMode = false;
    protected String sDecodeType = null;
    private String serviceVersion = null;
    public Vector vList = new Vector();
    public Hashtable hTable = new Hashtable();
    public Hashtable wmiHashTable = new Hashtable();
    protected WMIService lWMI = new WMIService();
    private String[] globalStatisticsBuffer;
    public int deviceNumber = 0;

    public DLSBaseService() {
        String ver = new Integer(1013044).toString();
        this.serviceVersion = new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(5, 7));
        this.log.log(this, "Device Service Version: " + this.serviceVersion);
        Iterator<Map.Entry<Object, Object>> i$ = System.getProperties().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<Object, Object> s = i$.next();
            this.log.log(this, s.getKey() + ": " + s.getValue());
        }
    }

    public String getCheckHealthText() throws JposException {
        this.log.in(this, "getCheckHealthText: " + this.strCheckHealthText);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCheckHealthText");
        return this.strCheckHealthText;
    }

    public boolean getClaimed() throws JposException {
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        return this.bClaimed;
    }

    public boolean getDeviceEnabled() throws JposException {
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        return this.bEnabled;
    }

    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        this.log.in(this, "setDeviceEnabled: " + deviceEnabled);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        this.bEnabled = deviceEnabled;
        try {
            this.deviceState = 3;
            if (deviceEnabled) {
                this.device.enable();
            } else {
                this.device.disable();
            }
            this.deviceState = 2;
            if (this.bEnabled) {
                this.sendDataEvent();
            }
        }
        catch (DLSException e) {
            this.log.error(this, "Error enabling/disabling device: " + e.getMessage());
            throw new JposException(111, e.getMessage());
        }
        this.log.out(this, "setDeviceEnabled");
    }

    public int getDeviceNumber() throws JposException {
        this.log.in(this, "getDeviceNumber");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        this.log.out(this, "getDeviceNumber");
        return this.device.deviceInfo.deviceNumber;
    }

    public void setDeviceNumber(int deviceNum) throws JposException {
        this.log.in(this, "setDeviceNumber: " + deviceNum);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        this.deviceNumber = deviceNum;
        this.device.deviceInfo.deviceNumber = deviceNum;
        this.log.out(this, "setDeviceNumber");
    }

    public String getDeviceServiceDescription() throws JposException {
        this.log.in(this, "getDeviceServiceDescription");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        String str = "Scanner";
        if (this.device != null) {
            this.log.log(this, "device != null");
            if (this.getCapStatisticsReporting()) {
                this.log.log(this, "getCapStatisticsReporting()");
                str = this.device.getDeviceInfo().getProductDescription();
                String sstr = "";
                sstr = this.device.getClass().getCanonicalName();
                if (sstr.contains("Scale")) {
                    sstr = this.device.getClass().getMethods().toString();
                    DLSScaleConfig config = (DLSScaleConfig)this.device.getConfiguration();
                    if (config != null) {
                        if (config.getMetricWeightMode()) {
                            this.nMaxWeight = config.getFiveDigitWeight() ? 15000 : 1500;
                            this.nWeightUnit = 2;
                            this.bMetricMode = true;
                        } else {
                            this.nMaxWeight = config.getFiveDigitWeight() ? 30000 : 3000;
                            this.nWeightUnit = 4;
                            this.bMetricMode = false;
                        }
                    }
                }
            }
        }
        this.log.out(this, "getDeviceServiceDescription: " + str);
        return str;
    }

    public int getDeviceServiceVersion() throws JposException {
        this.log.in(this, "getDeviceServiceVersion: 1013044");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getDeviceServiceVersion");
        return 1013044;
    }

    public int getVersion() {
        return 1013044;
    }

    public boolean getFreezeEvents() throws JposException {
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        return this.bFreezeEvents;
    }

    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        this.log.in(this, "setFreezeEvents: " + freezeEvents);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.bFreezeEvents = freezeEvents;
        if (!this.bFreezeEvents) {
            this.sendDataEvent();
        }
        this.log.out(this, "setFreezeEvents");
    }

    public String getPhysicalDeviceDescription() throws JposException {
        this.log.out(this, "getPhysicalDeviceDescription");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        String str = "";
        if (this.device != null) {
            str = this.device.getDeviceInfo().getDeviceDescription();
        }
        this.log.out(this, "getPhysicalDeviceDescription: " + str);
        return str;
    }

    public String getPortName() {
        this.log.out(this, "getPortName");
        String str = "";
        if (this.device != null) {
            str = this.device.getDeviceInfo().portName;
        }
        this.log.out(this, "getPortName: " + str);
        return str;
    }

    public String getPhysicalDeviceName() throws JposException {
        this.log.in(this, "getPhysicalDeviceName");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        String str = "";
        if (this.device != null) {
            str = this.device.getDeviceInfo().getDeviceName();
        }
        this.log.out(this, "getPhysicalDeviceName: " + str);
        return str;
    }

    public int getState() throws JposException {
        return this.deviceState;
    }

    public void open(String logicalName, EventCallbacks cb) throws JposException {
        this.log.in(this, "open: " + logicalName);
        this.strLogicalName = logicalName;
        this.evtCallback = cb;
        this.deviceState = 2;
        this.log.out(this, "open");
    }

    public void close() throws JposException {
        this.log.in(this, "close");
        try {
            if (this.getClaimed()) {
                this.release();
            }
            this.deviceState = 1;
        }
        catch (JposException e) {
            this.log.error(this, e.getMessage());
        }
        this.beenClaimed = false;
        this.log.out(this, "close");
    }

    public void claim(int timeout) throws JposException {
        this.log.in(this, "BaseService claim");
        if (this.getClaimed()) {
            return;
        }
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        try {
            this.device.claim(timeout);
            this.bClaimed = true;
            this.device.addDeviceErrorListener(this);
            this.device.addDeviceStatusListener(this);
            this.device.addDirectIODataListener(this);
            this.device.deviceInfo.setServiceVersion(this.serviceVersion);
        }
        catch (DLSException e) {
            DLSProperties options = DLSProperties.getInstance();
            DLSDeviceInfo dlsInfo = this.device.getDeviceInfo();
            String scannerInfoFilename = dlsInfo.getDeviceClass() + "_" + options.get("com.dls.jpos.common.ScannerService.ScannerInfoFilename", "RS232Scanner_scanner_info.txt");
            if (this.log.strLogFileDir != null) {
                scannerInfoFilename = this.log.strLogFileDir + scannerInfoFilename;
            }
            String[] parts = scannerInfoFilename.split("\\.");
            String scannerInfoAvalancheFilename = parts[0] + ".prf";
            boolean avalancheEnabled = options.get("com.dls.jpos.common.ScannerService.AvalancheEnabled", false);
            if (avalancheEnabled && this.log.strOS.contains("WINDOWS")) {
                boolean success;
                boolean fileExists;
                String propsPath = "";
                try {
                    propsPath = DLSRegistry.readString(-2147483646, "Software\\Wavelink\\Avalanche", "PROPS");
                }
                catch (IllegalArgumentException ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
                catch (IllegalAccessException ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
                catch (InvocationTargetException ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
                boolean exists = new File(propsPath).exists();
                if (exists && (fileExists = new File(propsPath + "\\" + scannerInfoAvalancheFilename).exists()) && !(success = new File(propsPath + "\\" + scannerInfoAvalancheFilename).delete())) {
                    this.log.error(this, "fail of deletion of file: " + propsPath + "\\" + scannerInfoAvalancheFilename);
                }
            }
            throw new JposException(111, e.getMessage());
        }
        this.log.out(this, "BaseService claim");
    }

    public void release() throws JposException {
        this.log.in(this, "release");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        try {
            this.device.removeDirectIODataListener(this);
            this.device.removeDeviceStatusListener(this);
            this.device.removeDeviceErrorListener(this);
            this.device.release();
        }
        catch (DLSException e) {
            this.log.error(this, e.getMessage());
            throw new JposException(111, e.getMessage());
        }
        this.bClaimed = false;
        this.log.out(this, "release");
    }

    public void checkHealth(int level) throws JposException {
        this.log.in(this, "checkHealth: " + level);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        switch (level) {
            case 1: {
                try {
                    if (this.device.isAlive()) {
                        this.strCheckHealthText = "Internal HCheck: Successful";
                        break;
                    }
                    this.strCheckHealthText = "Internal HCheck: Not Successful";
                }
                catch (DLSException e) {
                    this.strCheckHealthText = "Internal HCheck: Not Successful: " + e.getMessage();
                }
                break;
            }
            case 2: {
                try {
                    if (this.device.doHealthCheck()) {
                        this.strCheckHealthText = "External HCheck: Successful";
                        break;
                    }
                    this.strCheckHealthText = "External HCheck: Not Successful";
                }
                catch (DLSException e) {
                    this.strCheckHealthText = "External HCheck: Not Successful: " + e.getMessage();
                }
                break;
            }
            case 3: {
                this.strCheckHealthText = "Interactive HCheck: Not Supported";
            }
        }
        this.log.out(this, "checkHealth");
    }

    public void directIO(int command, int[] data, Object object) throws JposException {
        this.log.in(this, "directIO: " + command);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        try {
            this.device.directIO(command, data, object);
        }
        catch (DLSException e) {
            this.log.error(this, "directIO: " + e.getMessage());
            throw new JposException(111, e.getMessage());
        }
        this.log.out(this, "directIO");
    }

    public void resetStatistics(String statisticsBuffer) throws JposException {
        this.log.in(this, "resetStatistics");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.log.out(this, "resetStatistics");
        throw new JposException(106, "resetStatistics Not supported");
    }

    public boolean getCapStatisticsReporting() throws JposException {
        this.log.in(this, "getCapStatisticsReporting");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapStatisticsReporting");
        return this.device.hasStatisticsReporting();
    }

    public boolean getCapUpdateStatistics() throws JposException {
        this.log.in(this, "getCapUpdateStatistics");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapUpdateStatistics");
        return false;
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        this.log.in(this, "getCapCompareFirmwareVersion");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapCompareFirmwareVersion");
        return false;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        this.log.in(this, "getCapUpdateFirmware");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapUpdateFirmware");
        return false;
    }

    public boolean getCapStatusUpdate() throws JposException {
        this.log.in(this, "getCapStatusUpdate");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapStatusUpdate");
        return false;
    }

    public boolean getDeleteImageFileAfterRead() throws JposException {
        this.log.in(this, "getCapStatusUpdate");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapStatusUpdate");
        return this.device.getDeviceInfo().getDeleteImageFileAfterRead();
    }

    public int getCapPowerReporting() throws JposException {
        this.log.in(this, "getCapPowerReporting");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapPowerReporting");
        return 0;
    }

    public int getPowerNotify() throws JposException {
        this.log.in(this, "getPowerNotify");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getPowerNotify");
        return 0;
    }

    public boolean getEnabled() {
        this.log.in(this, "getEnabled");
        this.log.out(this, "getEnabled");
        return this.bEnabled;
    }

    public void setEnabled(boolean enb) {
        this.log.in(this, "setEnabled");
        this.bEnabled = enb;
        this.log.out(this, "setEnabled");
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        this.log.in(this, "setPowerNotify: " + powerNotify);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "setPowerNotify");
        throw new JposException(106, "setPowerNotify Not supported");
    }

    public int getPowerState() throws JposException {
        this.log.in(this, "getPowerState");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getPowerState");
        return 2000;
    }

    public void getUsableStatistics(String[] statisticsBuffer) throws JposException {
        ArrayList<String> items = new ArrayList<String>();
        this.log.in(this, "getUsableStatistics");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        try {
            Hashtable table = this.device.getStatistics();
            Object field = null;
            String category = (String)table.get(DLS_S_DEVICE_CATEGORY);
            if (category == null) {
                this.log.error(this, "Error getting device category from statistics.");
                throw new JposException(111, "Device category unknown");
            }
            String pad = new String(" ...........................");
            Vector v = new Vector(table.keySet());
            Collections.sort(v);
            Enumeration e = v.elements();
            boolean bTest = false;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                for (int i = 0; i < statisticsBuffer.length && !(bTest = key.contains(statisticsBuffer[i])); ++i) {
                }
                if (!bTest) continue;
                String value = (String)table.get(key);
                items.add(key + "\t" + value);
                key = key + pad;
                this.log.trace(this, "** Stats ** " + key.substring(0, 32) + " " + value);
                bTest = false;
            }
        }
        catch (DLSException ex) {
            this.log.error(this, "Enumeration error: " + ex);
        }
        catch (NullPointerException npe) {
            System.out.println("NullPointerException" + npe);
        }
        if (statisticsBuffer.length >= items.size()) {
            for (int i = 0; i < items.size(); ++i) {
                statisticsBuffer[i] = (String)items.get(i);
            }
        }
        this.log.out(this, "getUsableStatisticsStatistics");
    }

    public String[] commaSeparatedStringToStringArray(String aString) {
        String[] splittArray = null;
        if ((aString = aString.replaceAll(" ", "")) != null || !aString.equalsIgnoreCase("")) {
            splittArray = aString.split(",");
        }
        return splittArray;
    }

    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        boolean bUPOSRetrieve = false;
        boolean bManufacturerRetrieve = false;
        boolean bRetrieveAll = false;
        boolean bStatsSpecificRetrieve = false;
        DLSProperties options = DLSProperties.getInstance();
        if (!this.firstTime) {
            System.arraycopy(this.globalStatisticsBuffer, 0, statisticsBuffer, 0, 1);
            return;
        }
        String[] myLocalStatisticsBuffer = new String[100];
        myLocalStatisticsBuffer = statisticsBuffer[0].contains(",") ? this.commaSeparatedStringToStringArray(statisticsBuffer[0]) : statisticsBuffer;
        this.log.in(this, "retrieveStatistics");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        String str = this.device.getDeviceInfo().getProductDescription();
        if (str.contains("Scanner") && !this.getCapStatisticsReporting()) {
            this.getUsableStatistics(statisticsBuffer);
            return;
        }
        if (statisticsBuffer[0].equals("U_")) {
            bUPOSRetrieve = true;
        }
        if (statisticsBuffer[0].equals("M_")) {
            bManufacturerRetrieve = true;
        }
        if (statisticsBuffer[0].equals("")) {
            bRetrieveAll = true;
        }
        if (myLocalStatisticsBuffer.length >= 1) {
            bStatsSpecificRetrieve = true;
        }
        if (statisticsBuffer[0].equals("R_")) {
            this.getUsableStatistics(statisticsBuffer);
            return;
        }
        if (statisticsBuffer[0].equals("W_")) {
            this.getUsableStatistics(statisticsBuffer);
            return;
        }
        try {
            String value;
            this.hTable = this.device.getStatistics();
            String category = null;
            String field = null;
            if (this.hTable.containsKey(DLS_S_DEVICE_CATEGORY) && (category = (String)this.hTable.get(DLS_S_DEVICE_CATEGORY)) == null) {
                this.log.error(this, "Error getting device category from statistics.");
                throw new JposException(111, "Device category unknown");
            }
            Enumeration en = this.hTable.keys();
            String pad = new String(" ...........................");
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (!this.hTable.containsKey(key) || key.contains("Raw")) continue;
                value = (String)this.hTable.get(key);
                key = key + pad;
                this.log.trace(this, "** Stats ** " + key.substring(0, 29) + " " + value);
            }
            String ver = new Integer(this.getDeviceServiceVersion()).toString();
            String controlVersion = new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4));
            String serviceVersion = new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(5, 7));
            this.hTable.put(DLS_S_SERVICE_VERSION, serviceVersion.toString());
            float fcv = Float.valueOf(controlVersion.trim()).floatValue();
            int cv = (int)(fcv * 100000.0f);
            this.hTable.put(DLS_S_CONTROL_VERSION, new Integer(cv));
            if (this.hTable.containsKey(DLS_S_SCANNER_REVISION)) {
                this.hTable.put(DLS_S_APPLICATION_REVISION, this.hTable.get(DLS_S_SCANNER_REVISION));
            }
            this.hTable.put(DLS_S_POWER_NOTIFY, new Integer(this.getPowerNotify()));
            this.hTable.put(DLS_S_POWER_STATE, new Integer(this.getPowerState()));
            Date now = new Date();
            SimpleDateFormat format = new SimpleDateFormat("HHmmssMMddyyyy");
            String date_out = format.format(now);
            this.hTable.put(DLS_S_INSTALL_DATE, date_out);
            this.hTable.put(DLS_S_MANUFACTURE_DATE, date_out);
            this.vList.add("<?xml version='1.0' ?>");
            this.vList.add("<UPOSStat version=\"" + controlVersion + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.nrf-arts.org/IXRetail/namespace/\" xsi:schemaLocation=\"http://www.nrf-arts.org/IXRetail/namespace/UPOSStat.xsd\">");
            this.hTable.put(DLS_S_UPOS_VERSION, controlVersion);
            this.vList.add("  <Event>");
            if (this.hTable.containsKey(DLS_S_GOOD_SCAN_COUNT) || this.hTable.containsKey(DLS_S_GOOD_WEIGHT_READ_COUNT)) {
                this.vList.add("    <Parameter>");
                if (category.equals("Scanner")) {
                    this.vList.add("      <Name>" + DLS_S_GOOD_SCAN_COUNT + "</Name>");
                    this.vList.add("      <Value>" + this.hTable.get(DLS_S_GOOD_SCAN_COUNT) + "</Value>");
                } else {
                    this.vList.add("      <Name>" + DLS_S_GOOD_WEIGHT_READ_COUNT + "</Name>");
                    this.vList.add("      <Value>" + this.hTable.get(DLS_S_GOOD_WEIGHT_READ_COUNT) + "</Value>");
                }
                this.vList.add("    </Parameter>");
            }
            if (bUPOSRetrieve || bRetrieveAll) {
                this.vList.add("    <Parameter>");
                this.vList.add("      <Name>" + DLS_S_CAP_PWR_REPORT + "</Name>");
                String tempResponse = this.getCapPowerReporting() == 2 ? "Advanced" : (this.getCapPowerReporting() == 1 ? "Standard" : "None");
                this.vList.add("      <Value>" + tempResponse + "</Value>");
                this.vList.add("    </Parameter>");
                this.hTable.put(DLS_S_CAP_PWR_REPORT, tempResponse);
                this.vList.add("    <Parameter>");
                this.vList.add("      <Name>" + DLS_S_CAP_STATS_REPORT + "</Name>");
                boolean tempBResponse = this.getCapStatisticsReporting();
                this.vList.add("      <Value>" + tempResponse + "</Value>");
                this.vList.add("    </Parameter>");
                this.hTable.put(DLS_S_CAP_STATS_REPORT, new Boolean(tempBResponse));
                this.vList.add("    <Parameter>");
                this.vList.add("      <Name>" + DLS_S_CAP_UPDATE_STATS + "</Name>");
                tempBResponse = this.getCapUpdateStatistics();
                this.vList.add("      <Value>" + (tempBResponse ? "True" : "False") + "</Value>");
                this.vList.add("    </Parameter>");
                this.hTable.put(DLS_S_CAP_UPDATE_STATS, new Boolean(tempBResponse));
                this.vList.add("    <Parameter>");
                this.vList.add("      <Name>" + DLS_S_CAP_COMP_FW_VER + "</Name>");
                tempBResponse = this.getCapCompareFirmwareVersion();
                this.vList.add("      <Value>" + (tempBResponse ? "True" : "False") + "</Value>");
                this.vList.add("    </Parameter>");
                this.hTable.put(DLS_S_CAP_COMP_FW_VER, new Boolean(tempBResponse));
                this.vList.add("    <Parameter>");
                this.vList.add("      <Name>" + DLS_S_CAP_UPDATE_FW + "</Name>");
                tempBResponse = this.getCapUpdateFirmware();
                this.vList.add("      <Value>" + (tempBResponse ? "True" : "False") + "</Value>");
                this.vList.add("    </Parameter>");
                this.hTable.put(DLS_S_CAP_UPDATE_FW, new Boolean(tempBResponse));
            }
            if (bManufacturerRetrieve || bRetrieveAll) {
                try {
                    for (int i = 0; i < sStatsList.length; ++i) {
                        field = sStatsList[i];
                        if (field == null || !this.hTable.containsKey(field)) continue;
                        value = this.hTable.get(field).toString();
                        this.vList.add("    <ManufacturerSpecific>");
                        this.vList.add("      <Name>" + field + "</Name>");
                        this.vList.add("      <Value>" + value + "</Value>");
                        this.vList.add("    </ManufacturerSpecific>");
                    }
                }
                catch (NullPointerException npe) {
                    System.out.println("NullPointerException" + npe);
                }
                catch (Exception ex) {
                    System.out.println("Exception" + ex);
                }
            }
            if (bStatsSpecificRetrieve) {
                try {
                    for (int i = 0; i < myLocalStatisticsBuffer.length; ++i) {
                        field = myLocalStatisticsBuffer[i];
                        if (field == null || !this.hTable.containsKey(field)) continue;
                        value = this.hTable.get(field).toString();
                        this.vList.add("    <ManufacturerSpecific>");
                        this.vList.add("      <Name>" + field + "</Name>");
                        this.vList.add("      <Value>" + value.toString() + "</Value>");
                        this.vList.add("    </ManufacturerSpecific>");
                    }
                }
                catch (NullPointerException npe) {
                    System.out.println("NullPointerException" + npe);
                }
            }
            this.hTable.put(DLS_S_CAPTION, this.device.getDeviceInfo().getVendorName());
            this.hTable.put(DLS_S_DESCRIPTION, this.device.getDeviceInfo().getDeviceDescription());
            this.hTable.put(DLS_S_PHYSICAL_DESCRIPTION, this.device.getDeviceInfo().getProductDescription());
            this.hTable.put(DLS_S_PHYSICAL_NAME, this.device.getDeviceInfo().getProductName());
            this.hTable.put(DLS_S_ASYNC_MODE, new Boolean(false));
            String model = null;
            String serial = null;
            String firmware = null;
            if (this.hTable.containsKey(DLS_S_MODEL_NAME)) {
                model = (String)this.hTable.get(DLS_S_MODEL_NAME);
            }
            if (this.hTable.containsKey(DLS_S_SERIAL_NUMBER)) {
                serial = (String)this.hTable.get(DLS_S_SERIAL_NUMBER);
            }
            if (this.hTable.containsKey(DLS_S_FIRMWARE_VERSION)) {
                firmware = (String)this.hTable.get(DLS_S_FIRMWARE_VERSION);
            }
            if (model == null) {
                model = "";
                this.hTable.put(DLS_S_SERIAL_NUMBER, model);
            }
            if (serial == null) {
                serial = "";
                this.hTable.put(DLS_S_SERIAL_NUMBER, serial);
            }
            if (firmware == null) {
                firmware = "";
                this.hTable.put(DLS_S_FIRMWARE_VERSION, firmware);
            }
            this.manufacturerName = this.device.getDeviceInfo().getVendorName();
            this.hTable.put(DLS_S_MANUFACTURE_NAME, this.manufacturerName);
            this.vList.add("  </Event>");
            this.vList.add("  <Equipment>");
            this.vList.add("    <UnifiedPOSVersion>" + controlVersion + "</UnifiedPOSVersion>");
            this.vList.add("    <DeviceCategory>" + category + "</DeviceCategory>");
            this.vList.add("    <ManufacturerName>" + this.manufacturerName + "</ManufacturerName>");
            this.vList.add("    <ModelName>" + model + "</ModelName>");
            this.vList.add("    <SerialNumber>" + serial + "</SerialNumber>");
            this.vList.add("    <FirmwareRevision>" + firmware + "</FirmwareRevision>");
            this.vList.add("    <Interface>" + this.hTable.get(DLS_S_INTERFACE) + "</Interface>");
            this.vList.add("    <InstallationDate>" + this.hTable.get(DLS_S_INSTALL_DATE) + "</InstallationDate>");
            this.vList.add("  </Equipment>");
            this.vList.add("</UPOSStat>");
            String[] strReturn = new String[this.vList.size()];
            Iterator it = this.vList.iterator();
            int i = 0;
            while (it.hasNext()) {
                value = (String)it.next();
                this.log.trace(this, value);
                statisticsBuffer[0] = statisticsBuffer[0] + value + "\n";
                strReturn[i] = value;
                ++i;
            }
            this.log.out(this, "retrieveStatistics");
        }
        catch (DLSException dlse) {
            this.log.error(this, dlse.getMessage());
            throw new JposException(106, dlse.getMessage());
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.globalStatisticsBuffer = statisticsBuffer;
        }
        this.LoadUpWMIHashTable(this.hTable);
        String scannerInfoFile = this.scannerInfoFile(this.hTable);
        this.vList.clear();
        this.log.out(this, "retrieveStatistics");
    }

    public void retrieveScaleStatistics(String[] statisticsBuffer) throws JposException {
        this.log.in(this, "retrieveScaleStatistics");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        try {
            DLSDeviceInfo dlsInfo = this.device.getDeviceInfo();
            DLSCConfig dlsConfig = this.device.getConfiguration();
            String test = dlsInfo.getOption(DLS_S_SCALE_STAT_UPDATE);
            this.hTable = this.device.getStatistics();
            this.hTable.put("UnifiedPOSVersion", "1.12.0");
            this.hTable.put(DLS_S_CAP_PWR_REPORT, this.getCapPowerReporting() == 2 ? "Advanced" : (this.getCapPowerReporting() == 1 ? "Standard" : "None"));
            this.hTable.put(DLS_S_CAP_STATS_REPORT, this.getCapStatisticsReporting() ? "True" : "False");
            this.hTable.put(DLS_S_CAP_UPDATE_STATS, this.getCapUpdateStatistics() ? "True" : "False");
            this.hTable.put(DLS_S_CAP_COMP_FW_VER, this.getCapCompareFirmwareVersion() ? "True" : "False");
            this.hTable.put(DLS_S_CAP_UPDATE_FW, this.getCapUpdateFirmware() ? "True" : "False");
            String model = (String)this.hTable.get(DLS_S_MODEL_NAME);
            String serial = (String)this.hTable.get(DLS_S_SERIAL_NUMBER);
            String firmware = (String)this.hTable.get(DLS_S_FIRMWARE_VERSION);
            if (model == null) {
                model = "";
                this.hTable.put(DLS_S_SERIAL_NUMBER, model);
            }
            if (serial == null) {
                serial = "";
                this.hTable.put(DLS_S_SERIAL_NUMBER, serial);
            }
            if (firmware == null) {
                firmware = "";
                this.hTable.put(DLS_S_FIRMWARE_VERSION, firmware);
            }
            String ver = new Integer(this.getDeviceServiceVersion()).toString();
            String controlVersion = new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4));
            String serviceVersion = new Integer(ver.substring(0, 1)) + "." + new Integer(ver.substring(1, 4)) + "." + new Integer(ver.substring(5, 7));
            String version = this.getDeviceServiceVersion() / 1000000 + "." + this.getDeviceServiceVersion() % 10000 / 1000;
            this.hTable.put(DLS_S_SERVICE_VERSION, serviceVersion.toString());
            float fcv = Float.valueOf(controlVersion.trim()).floatValue();
            int cv = (int)(fcv * 100000.0f);
            this.hTable.put(DLS_S_CONTROL_VERSION, new Integer(cv));
            this.log.out(this, "retrieveStatistics");
        }
        catch (DLSException dlse) {
            this.log.error(this, dlse.getMessage());
            throw new JposException(106, dlse.getMessage());
        }
        this.log.out(this, "retrieveScaleStatistics");
    }

    public void updateStatistics(String statisticsBuffer) throws JposException {
        this.log.in(this, "updateStatistics");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.log.out(this, "updateStatistics");
        throw new JposException(106, "updateStatistics Not supported");
    }

    protected void sendDataEvent() {
        this.log.trace(this, "In sendDataEvent - should not be here");
    }

    public void onDeviceError(int nErrorCode) {
        this.log.trace(this, "In onDeviceError: " + nErrorCode);
    }

    public void onDeviceStatus(int nStatusCode) {
        this.log.trace(this, "In onDeviceStatus" + nStatusCode);
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        this.log.trace(this, "In compareFirmwareVersion: " + firmwareFileName);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        this.log.trace(this, "In updateFirmware: " + firmwareFileName);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
    }

    public void onDirectIOData(int cmd, byte[] buf) {
        this.log.in(this, "onDirectIOData, cmd=" + cmd);
        try {
            if (buf != null && buf.length != 0) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                bs.write(buf);
                this.evtCallback.fireDirectIOEvent(new DirectIOEvent(this, cmd, 0, bs));
            } else {
                this.log.error(this, "buf size is zero/null");
            }
        }
        catch (IOException ioe) {
            this.log.error(this, "Error writing to byte array output stream." + ioe.getMessage().toString());
        }
        this.log.out(this, "onDirectIOData");
    }

    private void LoadUpWMIHashTable(Hashtable ht) {
        Object value = null;
        for (int i = 0; i < namesWMI.length; ++i) {
            String WMIname = namesWMI[i];
            String UPOSname = namesUPOS[i];
            if (ht.containsKey(UPOSname)) {
                value = ht.get(UPOSname);
            }
            if (value == null) continue;
            this.wmiHashTable.put(WMIname, value);
        }
    }

    public String scannerInfoFile(Hashtable scanHT) {
        this.log.in(this, "scannerInfoFile");
        String headerMsg = new String();
        String msg = new String();
        String scannerMsg = new String();
        headerMsg = headerMsg + "# Raw data from scanner/scale\n";
        if (scanHT.containsKey("RawInfo")) {
            headerMsg = headerMsg + "# Info command\n";
            headerMsg = headerMsg + scanHT.get("RawInfo") + "\n";
        }
        if (scanHT.containsKey("RawHealth")) {
            headerMsg = headerMsg + "# Health command\n";
            headerMsg = headerMsg + scanHT.get("RawHealth") + "\n";
        }
        if (scanHT.containsKey("RawStats")) {
            headerMsg = headerMsg + "# Stats command\n";
            headerMsg = headerMsg + scanHT.get("RawStats") + "\n";
        }
        msg = msg + "# Info\n";
        if (scanHT.containsKey(DLS_S_MODEL_NAME)) {
            msg = msg + DLS_S_MODEL_NAME + " = " + scanHT.get(DLS_S_MODEL_NAME) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SERIAL_NUMBER)) {
            msg = msg + DLS_S_SERIAL_NUMBER + " = " + scanHT.get(DLS_S_SERIAL_NUMBER) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCANNER_BOARD_SERIAL)) {
            msg = msg + DLS_S_SCANNER_BOARD_SERIAL + " = " + scanHT.get(DLS_S_SCANNER_BOARD_SERIAL) + "\n";
        }
        if (scanHT.containsKey(DLS_S_FIRMWARE_VERSION)) {
            msg = msg + DLS_S_FIRMWARE_VERSION + " = " + scanHT.get(DLS_S_FIRMWARE_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCANNER_REVISION)) {
            msg = msg + DLS_S_SCANNER_REVISION + " = " + scanHT.get(DLS_S_SCANNER_REVISION) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCANNER_CONFIG_FILE_ID)) {
            msg = msg + DLS_S_SCANNER_CONFIG_FILE_ID + " = " + scanHT.get(DLS_S_SCANNER_CONFIG_FILE_ID) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCANNER_BOOT_ROM_ID)) {
            msg = msg + DLS_S_SCANNER_BOOT_ROM_ID + " = " + scanHT.get(DLS_S_SCANNER_BOOT_ROM_ID) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_RADIO_VERSION)) {
            msg = msg + DLS_HH_RADIO_VERSION + " = " + scanHT.get(DLS_HH_RADIO_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_S_UNIVERSAL_ROM_ID)) {
            msg = msg + DLS_S_UNIVERSAL_ROM_ID + " = " + scanHT.get(DLS_S_UNIVERSAL_ROM_ID) + "\n";
        }
        if (scanHT.containsKey(DLS_S_UNIVERSAL_BOOT_ROM_ID)) {
            msg = msg + DLS_S_UNIVERSAL_BOOT_ROM_ID + " = " + scanHT.get(DLS_S_UNIVERSAL_BOOT_ROM_ID) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCALE_INFO)) {
            msg = msg + DLS_S_SCALE_INFO + " = " + scanHT.get(DLS_S_SCALE_INFO) + "\n";
        }
        if (scanHT.containsKey(DLS_S_DISPLAY_VERSION)) {
            msg = msg + DLS_S_DISPLAY_VERSION + " = " + scanHT.get(DLS_S_DISPLAY_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_S_EAS_VERSION)) {
            msg = msg + DLS_S_EAS_VERSION + " = " + scanHT.get(DLS_S_EAS_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCANNER_INTERFACE)) {
            msg = msg + DLS_S_SCANNER_INTERFACE + " = " + scanHT.get(DLS_S_SCANNER_INTERFACE) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_RADIO_APP_VERSION)) {
            msg = msg + DLS_HH_RADIO_APP_VERSION + " = " + scanHT.get(DLS_HH_RADIO_APP_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_RADIO_APP_VERSION)) {
            msg = msg + DLS_HH_RADIO_APP_VERSION + " = " + scanHT.get(DLS_HH_RADIO_APP_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_RADIO_BOOTLOADER_VERSION)) {
            msg = msg + DLS_HH_RADIO_BOOTLOADER_VERSION + " = " + scanHT.get(DLS_HH_RADIO_BOOTLOADER_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_MODEL_NAME)) {
            msg = msg + DLS_HH_MODEL_NAME + " = " + scanHT.get(DLS_HH_MODEL_NAME) + "\n";
        }
        msg = msg + "# Health\n";
        if (scanHT.containsKey(DLS_S_MOTOR_HEALTH)) {
            msg = msg + DLS_S_MOTOR_HEALTH + " = " + scanHT.get(DLS_S_MOTOR_HEALTH) + "\n";
        }
        if (scanHT.containsKey(DLS_S_V_LASER_HEALTH)) {
            msg = msg + DLS_S_V_LASER_HEALTH + " = " + scanHT.get(DLS_S_V_LASER_HEALTH) + "\n";
        }
        if (scanHT.containsKey(DLS_S_H_LASER_HEALTH)) {
            msg = msg + DLS_S_H_LASER_HEALTH + " = " + scanHT.get(DLS_S_H_LASER_HEALTH) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCALE_HEALTH)) {
            msg = msg + DLS_S_SCALE_HEALTH + " = " + scanHT.get(DLS_S_SCALE_HEALTH) + "\n";
        }
        if (scanHT.containsKey(DLS_S_REMOTE_DISPLAY_HEALTH)) {
            msg = msg + DLS_S_REMOTE_DISPLAY_HEALTH + " = " + scanHT.get(DLS_S_REMOTE_DISPLAY_HEALTH) + "\n";
        }
        if (scanHT.containsKey(DLS_S_EAS_HEALTH)) {
            msg = msg + DLS_S_EAS_HEALTH + " = " + scanHT.get(DLS_S_EAS_HEALTH) + "\n";
        }
        if (scanHT.containsKey(DLS_S_CAMERA_HEALTH)) {
            msg = msg + DLS_S_CAMERA_HEALTH + " = " + scanHT.get(DLS_S_CAMERA_HEALTH) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_RADIO_HEALTH)) {
            msg = msg + DLS_HH_RADIO_HEALTH + " = " + scanHT.get(DLS_HH_RADIO_HEALTH) + "\n";
        }
        msg = msg + "# Stats\n";
        if (scanHT.containsKey(DLS_S_SCANNER_TIME)) {
            msg = msg + DLS_S_SCANNER_TIME + " = " + scanHT.get(DLS_S_SCANNER_TIME) + "\n";
        }
        if (scanHT.containsKey(DLS_S_HOURS_POWERED_COUNT)) {
            msg = msg + DLS_S_HOURS_POWERED_COUNT + " = " + scanHT.get(DLS_S_HOURS_POWERED_COUNT) + "\n";
        }
        if (scanHT.containsKey(DLS_S_LASER_TIME)) {
            msg = msg + DLS_S_LASER_TIME + " = " + scanHT.get(DLS_S_LASER_TIME) + "\n";
        }
        if (scanHT.containsKey(DLS_S_GOOD_SCAN_COUNT)) {
            msg = msg + DLS_S_GOOD_SCAN_COUNT + " = " + scanHT.get(DLS_S_GOOD_SCAN_COUNT) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCALE_ZEROS)) {
            msg = msg + DLS_S_SCALE_ZEROS + " = " + scanHT.get(DLS_S_SCALE_ZEROS) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCALE_CALS)) {
            msg = msg + DLS_S_SCALE_CALS + " = " + scanHT.get(DLS_S_SCALE_CALS) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SCALE_CAL_TIME)) {
            msg = msg + DLS_S_SCALE_CAL_TIME + " = " + scanHT.get(DLS_S_SCALE_CAL_TIME) + "\n";
        }
        if (scanHT.containsKey(DLS_S_EAS_DEACTIVATED)) {
            msg = msg + DLS_S_EAS_DEACTIVATED + " = " + scanHT.get(DLS_S_EAS_DEACTIVATED) + "\n";
        }
        if (scanHT.containsKey(DLS_S_EAS_MANUAL)) {
            msg = msg + DLS_S_EAS_MANUAL + " = " + scanHT.get(DLS_S_EAS_MANUAL) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_BATTERY_CHG_CYCLES)) {
            msg = msg + DLS_HH_BATTERY_CHG_CYCLES + " = " + scanHT.get(DLS_HH_BATTERY_CHG_CYCLES) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_TRIGGER_PULLS)) {
            msg = msg + DLS_HH_TRIGGER_PULLS + " = " + scanHT.get(DLS_HH_TRIGGER_PULLS) + "\n";
        }
        if (scanHT.containsKey(DLS_HH_KEY_PRESSES)) {
            msg = msg + DLS_HH_KEY_PRESSES + " = " + scanHT.get(DLS_HH_KEY_PRESSES) + "\n";
        }
        headerMsg = headerMsg + "#\n";
        if (scanHT.containsKey(DLS_S_MODEL_NAME)) {
            String modelNumPieces = (String)scanHT.get(DLS_S_MODEL_NAME);
            String[] begin = modelNumPieces.split("-");
            headerMsg = headerMsg + "vendor = " + begin[0] + "\n";
        } else {
            headerMsg = headerMsg + "vendor = " + scanHT.get(DLS_S_MANUFACTURE_NAME) + "\n";
        }
        headerMsg = headerMsg + "# UPOS\n";
        headerMsg = headerMsg + DLS_S_MANUFACTURE_NAME + " = " + scanHT.get(DLS_S_MANUFACTURE_NAME) + "\n";
        headerMsg = headerMsg + DLS_S_DEVICE_CATEGORY + " = " + scanHT.get(DLS_S_DEVICE_CATEGORY) + "\n";
        headerMsg = headerMsg + DLS_S_INTERFACE + " = " + scanHT.get(DLS_S_INTERFACE) + "\n";
        msg = msg + "#\n";
        msg = msg + "# JavaPOS \n";
        if (scanHT.containsKey(DLS_S_UPOS_VERSION)) {
            msg = msg + "# " + DLS_S_UPOS_VERSION + " = " + scanHT.get(DLS_S_UPOS_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_S_CONTROL_VERSION)) {
            msg = msg + "# " + DLS_S_CONTROL_VERSION + " = " + scanHT.get(DLS_S_CONTROL_VERSION) + "\n";
        }
        if (scanHT.containsKey(DLS_S_SERVICE_VERSION)) {
            msg = msg + "# " + DLS_S_SERVICE_VERSION + " = " + scanHT.get(DLS_S_SERVICE_VERSION) + "\n";
        }
        DateFormat fDateFormat = DateFormat.getDateTimeInstance(2, 2);
        Date now = new Date();
        String date_out = fDateFormat.format(now);
        msg = msg + "#\n";
        msg = msg + "# Creation date: \t" + date_out + "\r\n";
        msg = msg + "# Copyright 2012, Datalogic ADC, Inc.\r\n";
        msg = msg + "# EOF\r\n";
        scannerMsg = headerMsg + msg;
        try {
            BufferedWriter out;
            boolean scannerInfoFileExists;
            DLSProperties options = DLSProperties.getInstance();
            DLSDeviceInfo dlsInfo = this.device.getDeviceInfo();
            String scannerInfoFilename = dlsInfo.getDeviceClass() + "_" + options.get("com.dls.jpos.common.ScannerService.ScannerInfoFilename", "RS232Scanner_scanner_info.txt");
            if (this.log.strLogFileDir != null) {
                scannerInfoFilename = this.log.strLogFileDir + scannerInfoFilename;
            }
            this.log.log(this, "scannerInfoFilename = " + scannerInfoFilename);
            String[] parts = scannerInfoFilename.split("\\.");
            String scannerInfoAvalancheFilename = parts[0] + ".prf";
            this.log.log(this, "scannerInfoAvalancheFilename = " + scannerInfoAvalancheFilename);
            boolean avalancheEnabled = options.get("com.dls.jpos.common.ScannerService.AvalancheEnabled", false);
            if (avalancheEnabled && this.log.strOS.contains("WINDOWS")) {
                String propsPath = "";
                try {
                    propsPath = DLSRegistry.readString(-2147483646, "Software\\Wavelink\\Avalanche", "PROPS");
                }
                catch (IllegalArgumentException ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
                catch (IllegalAccessException ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
                catch (InvocationTargetException ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
                if (propsPath != null) {
                    this.log.log(this, "Avalanche PROPS directory = " + propsPath);
                    boolean exists = new File(propsPath).exists();
                    if (!exists) {
                        this.log.log(this, "making dirs = " + propsPath);
                        boolean bMkDir = new File(propsPath).mkdirs();
                    }
                    File scannerAvalancheInfoFile = new File(propsPath + "\\" + "_" + scannerInfoAvalancheFilename);
                    this.log.log(this, "writing file: " + propsPath + "\\" + scannerInfoAvalancheFilename);
                    scannerAvalancheInfoFile.createNewFile();
                    BufferedWriter aOut = new BufferedWriter(new FileWriter(scannerAvalancheInfoFile));
                    aOut.write(scannerMsg);
                    aOut.close();
                }
            }
            if (!(scannerInfoFileExists = new File(scannerInfoFilename).exists())) {
                File scannerInfoFile = new File(scannerInfoFilename);
                scannerInfoFile.createNewFile();
                out = new BufferedWriter(new FileWriter(scannerInfoFile));
                out.write(scannerMsg);
                out.close();
            } else {
                File scannerInfoFile = new File(scannerInfoFilename);
                out = new BufferedWriter(new FileWriter(scannerInfoFile));
                out.write(scannerMsg);
                out.close();
            }
        }
        catch (IOException e) {
            System.err.println("Jpos exception on createNewFile: " + e.toString() + "scannerinfo.txt\n");
            msg = msg + "Exception on createNewFile: " + e + "scannerinfo.txt";
        }
        this.log.out(this, "scannerInfoFile");
        return msg;
    }
}

