/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.DLSLogManager;
import java.lang.reflect.Constructor;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;

public class DLSScaleInstanceFactory
implements JposServiceInstanceFactory {
    protected DLSLogManager log = DLSLogManager.getInstance();

    public JposServiceInstance createInstance(String logicalName, JposEntry entry) throws JposException {
        this.log.in(this, "createInstance");
        if (!entry.hasPropertyWithName("serviceClass")) {
            this.log.error(this, "The JposEntry does not contain the 'serviceClass' property");
            throw new JposException(104, "The JposEntry does not contain the 'serviceClass' property");
        }
        JposServiceInstance serviceInstance = null;
        try {
            String serviceClassName = (String)entry.getPropertyValue("serviceClass");
            Class<?> serviceClass = Class.forName(serviceClassName);
            Class[] params = new Class[]{};
            Constructor<?> ctor = serviceClass.getConstructor(params);
            serviceInstance = (JposServiceInstance)ctor.newInstance(params);
        }
        catch (Exception e) {
            this.log.error(this, "Error creating ScaleServiceInstace: " + e.getMessage());
            throw new JposException(104, "Unable to instantiate the service instance");
        }
        this.log.out(this, "createInstance");
        return serviceInstance;
    }
}

