/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.transport.DLSPort;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Properties;

public class DLSUsbWin32
extends DLSPort {
    private int nAttachment = 0;
    private boolean bLoaded = false;
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    private synchronized native String nativeQueryDevice(int var1, int var2, int var3) throws Exception;

    private synchronized native boolean nativeOpenPort(String var1) throws Exception;

    private synchronized native boolean nativeClosePort() throws Exception;

    private synchronized native boolean nativeSendData(byte[] var1, int var2) throws Exception;

    private synchronized native boolean nativeStartLiveWeight(byte[] var1, int var2, int var3) throws Exception;

    private synchronized native boolean nativeStopLiveWeight() throws Exception;

    public DLSUsbWin32(DLSDeviceInfo info) {
        super(info);
        JavaLibraryPath jp = new JavaLibraryPath();
        try {
            String lib_path = System.getProperty("java.library.path");
            this.log.trace(this, "windows lib path: " + lib_path);
            System.loadLibrary("Win32Hid");
            this.bLoaded = true;
            return;
        }
        catch (UnsatisfiedLinkError e) {
            this.log.error(this, "error: unable to load Win32Hid.dll from current library path, create new lib path");
            String os_type = System.getProperty("os.name").toLowerCase();
            if (os_type.contains("windows")) {
                this.log.trace(this, "windows lib path: " + System.getProperty("user.dir") + ";" + System.getProperty("user.dir") + "\\SupportJars");
                try {
                    jp.add(System.getProperty("user.dir"));
                    jp.add(System.getProperty("user.dir") + "\\SupportJars");
                }
                catch (Exception ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
            } else {
                try {
                    jp.add(System.getProperty("user.dir"));
                    jp.add(System.getProperty("user.dir") + "/SupportJars");
                }
                catch (Exception ex) {
                    this.log.error(this, ex.getLocalizedMessage());
                }
            }
            try {
                System.loadLibrary("Win32Hid");
                this.bLoaded = true;
            }
            catch (UnsatisfiedLinkError e2) {
                this.log.error(this, "SEVERE error: unable to load Win32Hid.dll");
            }
            return;
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public boolean openPort() {
        if (!this.bLoaded) {
            this.log.error(this, "Win32Hid library not loaded....SEVERE error....");
            return false;
        }
        boolean bRc = true;
        this.log.in(this, "openPort");
        String strPath = "";
        try {
            strPath = this.nativeQueryDevice(this.info.getVendorId(), this.info.getProductId(), this.info.getUsage());
            this.nativeOpenPort(strPath);
            this.log.trace(this, "Opened usb port: " + strPath);
            this.bOpen = true;
        }
        catch (Exception e) {
            this.log.error(this, "Error: " + e.getMessage());
            bRc = false;
        }
        catch (UnsatisfiedLinkError e) {
            this.log.error(this, "Unstatisfied link error: " + e.getMessage());
            bRc = false;
        }
        this.log.out(this, "openPort");
        return bRc;
    }

    public boolean closePort() {
        if (!this.bLoaded) {
            this.log.error(this, "Win32Hid library not loaded....SEVERE error....");
            return false;
        }
        this.log.in(this, "closePort");
        try {
            this.nativeClosePort();
        }
        catch (Exception e) {
            this.log.error(this, "Exception on nativeClosePort: " + e.getMessage());
        }
        catch (UnsatisfiedLinkError e) {
            this.log.error(this, "Unstatisfied link error: " + e.getMessage());
        }
        this.bOpen = false;
        this.log.out(this, "closePort");
        return true;
    }

    public void changeBaudRate(int nBaud) {
    }

    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        if (!this.bLoaded) {
            this.log.error(this, "Win32Hid library not loaded....SEVERE error....");
            return false;
        }
        this.log.in(this, "startLiveWeight");
        try {
            this.nativeStartLiveWeight(buf, len, rate);
        }
        catch (Exception e) {
            this.log.error(this, "Error sending start live weight: " + e.getMessage());
        }
        catch (UnsatisfiedLinkError e) {
            this.log.error(this, "Unstatisfied link error: " + e.getMessage());
        }
        this.log.out(this, "startLiveWeight");
        return true;
    }

    public void stopLiveWeight() {
        if (!this.bLoaded) {
            this.log.error(this, "Win32Hid library not loaded....SEVERE error....");
            return;
        }
        try {
            this.nativeStopLiveWeight();
        }
        catch (Exception e) {
            this.log.error(this, "Error sending stop live weight: " + e.getMessage());
        }
        catch (UnsatisfiedLinkError e) {
            this.log.error(this, "Unstatisfied link error: " + e.getMessage());
        }
        this.log.out(this, "stopLiveWeight");
    }

    public int sendData(byte[] buf, int len) {
        if (!this.bLoaded) {
            this.log.error(this, "Win32Hid library not loaded....SEVERE error....");
            return 0;
        }
        this.log.in(this, "sendData");
        try {
            this.nativeSendData(buf, len);
        }
        catch (Exception e) {
            this.log.error(this, "Error sending data to port: " + e.getMessage());
        }
        catch (UnsatisfiedLinkError e) {
            this.log.error(this, "Unstatisfied link error, check dll version and location: " + e.getMessage());
        }
        String logData = "";
        for (int i = 0; i < len; ++i) {
            logData = logData + " 0x" + Integer.toHexString(buf[i] & 0xFF);
        }
        this.log.log(this, "# raw bytes sent[" + len + "]" + logData);
        this.log.out(this, "sendData");
        return 1;
    }

    public void onDeviceRemoved() {
        this.log.trace(this, "Device Removed: " + Integer.toHexString(this.info.getVendorId()) + "," + Integer.toHexString(this.info.getProductId()));
        this.fireDeviceRemovedEvent();
    }

    public void onDeviceReattached() {
        this.fireDeviceReattachedEvent();
    }

    public void onDataReceived(byte[] inBuf, int len) {
        this.fireDataReceivedEvent(inBuf, len);
    }

    public void logLog(String strMsg) {
        this.log.log(this, "C++: " + strMsg);
    }

    public void logError(String strMsg) {
        this.log.error(this, "C++: " + strMsg);
    }

    public void logIn(String strMsg) {
        this.log.in(this, "C++: " + strMsg);
    }

    public void logOut(String strMsg) {
        this.log.out(this, "C++: " + strMsg);
    }

    public boolean FWBusy() {
        return this.log.getFWBusy();
    }

    public class JavaLibraryPath {
        public void add(File path) throws Exception {
            String newLibraryPath = System.getProperty("java.library.path");
            newLibraryPath = newLibraryPath == null || newLibraryPath.length() < 1 ? path.getCanonicalPath() : newLibraryPath + File.pathSeparator + path.getCanonicalPath();
            Field f = (class$java$lang$System == null ? (class$java$lang$System = DLSUsbWin32.class$("java.lang.System")) : class$java$lang$System).getDeclaredField("props");
            f.setAccessible(true);
            Properties props = (Properties)f.get(null);
            props.put("java.library.path", newLibraryPath);
            Field usr_pathsField = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = DLSUsbWin32.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("usr_paths");
            usr_pathsField.setAccessible(true);
            String[] usr_paths = (String[])usr_pathsField.get(null);
            String[] newUsr_paths = new String[usr_paths == null ? 1 : usr_paths.length + 1];
            if (usr_paths != null) {
                System.arraycopy(usr_paths, 0, newUsr_paths, 0, usr_paths.length);
            }
            newUsr_paths[newUsr_paths.length - 1] = path.getAbsolutePath();
            usr_pathsField.set(null, newUsr_paths);
        }

        public void add(String sPath) throws Exception {
            File path = new File(sPath);
            this.add(path);
        }
    }
}

