/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.DLSLogManager;
import java.util.Hashtable;
import java.util.Iterator;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.simple.SimpleEntry;
import jpos.loader.JposServiceLoader;

public abstract class DLSCConfig {
    String[][] strConfigArray;
    private String strLogicalName;
    private String strTrue = "TRUE";
    private String strOne = "1";
    protected Hashtable mapConfig;
    protected DLSLogManager log = DLSLogManager.getInstance();
    protected static final String DLS_USB_FLASH = "DLS-USB-Flash";

    public DLSCConfig() {
        this.mapConfig = new Hashtable();
    }

    protected abstract String[][] getConfigArray();

    public boolean loadConfiguration(String strLogicalName) {
        int i;
        this.log.in(this, "loadConfiguration: " + strLogicalName);
        this.strConfigArray = this.getConfigArray();
        boolean bRc = true;
        this.strLogicalName = strLogicalName;
        for (int i2 = 0; i2 < this.strConfigArray.length; ++i2) {
            String put = this.mapConfig.put(this.strConfigArray[i2][0], this.strConfigArray[i2][1]);
        }
        JposEntryRegistry registry = JposServiceLoader.getManager().getEntryRegistry();
        JposEntry entry = registry.getJposEntry(strLogicalName);
        if (entry == null) {
            this.log.error(this, "Error loading configuration for: " + strLogicalName);
            this.log.out(this, "loadConfiguration");
            bRc = false;
            return bRc;
        }
        for (i = 0; i < this.strConfigArray.length; ++i) {
            this.strConfigArray[i][1] = this.readOption(entry, this.strConfigArray[i][0], this.strConfigArray[i][1]);
        }
        this.mapConfig.clear();
        for (i = 0; i < this.strConfigArray.length; ++i) {
            String put = this.mapConfig.put(this.strConfigArray[i][0], this.strConfigArray[i][1]);
        }
        this.log.out(this, "loadConfiguration");
        return bRc;
    }

    public boolean saveConfiguration() {
        this.log.in(this, "saveConfiguration: " + this.strLogicalName);
        if (this.strLogicalName == null) {
            this.log.out(this, "saveConfiguration");
            return false;
        }
        try {
            JposEntryRegistry registry = JposServiceLoader.getManager().getEntryRegistry();
            registry.load();
            JposEntry entry = registry.getJposEntry(this.strLogicalName);
            if (entry == null) {
                entry = new SimpleEntry();
                entry.addProperty("logicalName", this.strLogicalName);
                registry.addJposEntry(entry);
            }
            this.saveConfiguration(entry);
            registry.save();
        }
        catch (Exception e) {
            this.log.error(this, "Error saving configuration: " + this.strLogicalName + "," + e.getMessage());
            this.log.out(this, "saveConfiguration");
            return false;
        }
        this.log.out(this, "saveConfiguration");
        return true;
    }

    public boolean saveConfiguration(JposEntry entry) {
        this.log.in(this, "saveConfiguration");
        try {
            if (entry != null) {
                Iterator it = this.mapConfig.keySet().iterator();
                while (it.hasNext()) {
                    String element = (String)it.next();
                    if (entry.hasPropertyWithName(element)) {
                        entry.modifyPropertyValue(element, this.mapConfig.get(element));
                        continue;
                    }
                    entry.addProperty(element, this.mapConfig.get(element));
                }
            }
        }
        catch (Exception e) {
            this.log.error(this, "Error saving configuration: " + this.strLogicalName + "," + e.getMessage());
            this.log.out(this, "saveConfiguration");
            return false;
        }
        this.log.out(this, "saveConfiguration");
        return true;
    }

    public String getLogicalName() {
        return this.strLogicalName;
    }

    protected String readOption(JposEntry entry, String strOption, String strDefault) {
        String strRetValue = strDefault;
        String strValue = null;
        try {
            strValue = (String)entry.getPropertyValue(strOption);
        }
        catch (ClassCastException cce) {
            try {
                strValue = ((Integer)entry.getPropertyValue(strOption)).toString();
            }
            catch (ClassCastException cce2) {
                try {
                    Boolean b = (Boolean)entry.getPropertyValue(strOption);
                    strValue = b.booleanValue() ? "1" : "0";
                }
                catch (ClassCastException cce3) {
                    // empty catch block
                }
            }
        }
        if (strValue != null) {
            strRetValue = strValue;
        }
        return strRetValue;
    }

    public boolean getOptionAsBoolean(String strOption) {
        String strValue = this.getOption(strOption).toUpperCase();
        return strValue.equals(this.strTrue) || strValue.equals(this.strOne);
    }

    public int getOptionAsInt(String strOption) {
        String strValue = this.getOption(strOption);
        int nRet = 0;
        try {
            nRet = Integer.parseInt(strValue);
        }
        catch (NumberFormatException nfe) {
            this.log.error(this, "Error converting int: " + strOption + ":" + strValue);
        }
        return nRet;
    }

    public int getOptionAsIntHex(String strOption) {
        String strValue = this.getOption(strOption);
        int nRet = 0;
        try {
            nRet = Integer.parseInt(strValue, 16);
        }
        catch (NumberFormatException nfe) {
            this.log.error(this, "Error converting int: " + strOption + ":" + strValue);
        }
        return nRet;
    }

    public String getOption(String strOption) {
        String strValue = "";
        try {
            strValue = (String)this.mapConfig.get(strOption);
        }
        catch (NullPointerException npe) {
            this.log.error(this, "Error getOption: " + strOption + ": null");
        }
        return strValue;
    }

    public void setOption(String strOption, boolean bValue) {
        if (bValue) {
            this.setOption(strOption, "True");
        } else {
            this.setOption(strOption, "False");
        }
    }

    public void setOption(String strOption, int nValue) {
        this.setOption(strOption, Integer.toString(nValue));
    }

    public void setOption(String strOption, String strValue) {
        String put = this.mapConfig.put(strOption, strValue);
    }
}

