/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSLogManager;
import com.dls.jpos.common.DLSObjectFactory;
import com.dls.jpos.interpretation.DeviceErrorStatusListener;
import com.dls.jpos.interpretation.DirectIODataListener;
import com.dls.jpos.transport.DLSPort;
import com.dls.jpos.transport.DataReceivedListener;
import com.dls.jpos.transport.DeviceAddedListener;
import com.dls.jpos.transport.DeviceReattachedListener;
import com.dls.jpos.transport.DeviceRemovedListener;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DLSDevice
implements DataReceivedListener,
DeviceAddedListener,
DeviceRemovedListener,
DeviceReattachedListener {
    protected DLSLogManager log = DLSLogManager.getInstance();
    public DLSDeviceInfo deviceInfo = null;
    protected String strLogicalName = null;
    protected DLSPort port = null;
    protected Vector deviceErrorListeners = new Vector();
    protected Vector deviceStatusListeners = new Vector();
    protected Vector directIODataListeners = new Vector();
    protected boolean bAlive = false;
    protected int nTimeout = 5000;
    protected boolean bNeedBCC = false;
    protected int lastPos = 0;
    protected ByteArrayOutputStream bs = new ByteArrayOutputStream();
    Vector msgList = new Vector();
    protected Hashtable hTable;

    public void open(String strLogicalName) throws DLSException {
        this.log.in(this, "open");
        this.strLogicalName = strLogicalName;
        this.deviceInfo = new DLSDeviceInfo();
        this.deviceInfo.loadConfiguration(strLogicalName);
        this.log.out(this, "open");
    }

    public void close() throws DLSException {
        this.log.in(this, "close");
        if (this.port != null && this.port.isOpen()) {
            this.port.removeDataReceivedListener(this);
            this.log.log(this, "port.removeDataReceivedListener(this)");
            this.port.closePort();
            this.log.in(this, "port.closePort()");
            this.port = null;
        }
        this.log.out(this, "close");
    }

    public void claim(long lTimeout) throws DLSException {
        this.log.in(this, "Device claim");
        if (this.port != null && this.port.isOpen()) {
            this.port.closePort();
            this.release();
        }
        this.port = DLSObjectFactory.createPort(this.deviceInfo);
        if (!this.port.openPort()) {
            this.log.error(this, "Error opening port");
            throw new DLSException(-2147483644, "Port open error");
        }
        this.port.addDataReceivedListener(this);
        this.port.addDeviceAddedListener(this);
        this.port.addDeviceRemovedListener(this);
        this.port.addDeviceReattachedListener(this);
        this.log.out(this, "Device claim");
    }

    protected int sendMsg(String strMsg) {
        this.log.in(this, "sendMsg");
        StringBuffer msg = new StringBuffer();
        byte b = this.deviceInfo.getTxPrefix();
        if (b != 0) {
            msg.append((char)this.deviceInfo.getTxPrefix());
        }
        msg.append(strMsg);
        msg.append((char)this.deviceInfo.getTxTrailer());
        if (this.deviceInfo.getUseBCC()) {
            strMsg = strMsg + (char)this.deviceInfo.getTxTrailer();
            msg.append(this.blockCheckCharacter(strMsg));
        }
        this.log.out(this, "sendMsg");
        return this.port.sendData(msg.toString());
    }

    public void release() throws DLSException {
        this.log.in(this, "release");
        if (this.port != null && this.port.isOpen()) {
            this.port.closePort();
        }
        this.port.removeDataReceivedListener(this);
        this.port.removeDeviceAddedListener(this);
        this.port.removeDeviceRemovedListener(this);
        this.port.removeDeviceReattachedListener(this);
        this.log.out(this, "release");
    }

    public DLSDeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public abstract DLSCConfig getConfiguration();

    public abstract void enable() throws DLSException;

    public abstract void disable() throws DLSException;

    public abstract void doSelfTest() throws DLSException;

    public abstract boolean doHealthCheck() throws DLSException;

    public abstract boolean isAlive() throws DLSException;

    public abstract int sendJoin();

    public abstract int sendReset();

    public abstract void directIO(int var1, int[] var2, Object var3) throws DLSException;

    public abstract void reset() throws DLSException;

    public void addDeviceErrorListener(DeviceErrorStatusListener del) {
        this.log.in(this, "addDeviceErrorListener");
        this.deviceErrorListeners.addElement(del);
        this.log.out(this, "addDeviceErrorListener");
    }

    public void removeDeviceErrorListener(DeviceErrorStatusListener del) {
        this.log.in(this, "removeDeviceErrorListener");
        this.deviceErrorListeners.removeElement(del);
        this.log.out(this, "removeDeviceErrorListener");
    }

    protected void fireDeviceErrorEvent(int errorCode) {
        this.log.in(this, "fireDeviceErrorEvent: " + errorCode);
        Enumeration e = this.deviceErrorListeners.elements();
        while (e.hasMoreElements()) {
            DeviceErrorStatusListener listener = (DeviceErrorStatusListener)e.nextElement();
            listener.onDeviceError(errorCode);
        }
        this.log.out(this, "fireDeviceErrorEvent");
    }

    public void addDeviceStatusListener(DeviceErrorStatusListener dsl) {
        this.log.in(this, "addDeviceStatusListener");
        this.deviceStatusListeners.addElement(dsl);
        this.log.out(this, "addDeviceStatusListener");
    }

    public void removeDeviceStatusListener(DeviceErrorStatusListener dsl) {
        this.log.in(this, "removeDeviceStatusListener");
        boolean re = this.deviceStatusListeners.removeElement(dsl);
        this.log.out(this, "removeDeviceStatusListener");
    }

    protected void fireDeviceStatusEvent(int statusCode) {
        int STATUS_ALIVE = -200;
        int STATUS_NOT_ALIVE = -201;
        int STATUS_ENABLED = -202;
        int STATUS_NOT_ENABLED = -203;
        if (statusCode == STATUS_ALIVE) {
            this.log.in(this, "fireDeviceStatusEvent: STATUS_ALIVE " + statusCode);
        }
        if (statusCode == STATUS_NOT_ALIVE) {
            this.log.in(this, "fireDeviceStatusEvent: STATUS_NOT_ALIVE " + statusCode);
        }
        if (statusCode == STATUS_ENABLED) {
            this.log.in(this, "fireDeviceStatusEvent: STATUS_ENABLED " + statusCode);
        }
        if (statusCode == STATUS_NOT_ENABLED) {
            this.log.in(this, "fireDeviceStatusEvent: STATUS_NOT_ENABLED " + statusCode);
        }
        Enumeration e = this.deviceStatusListeners.elements();
        while (e.hasMoreElements()) {
            DeviceErrorStatusListener listener = (DeviceErrorStatusListener)e.nextElement();
            listener.onDeviceStatus(statusCode);
        }
        this.log.out(this, "fireDeviceStatusEvent");
    }

    public void addDirectIODataListener(DirectIODataListener dl) {
        this.log.in(this, "addDirectIODataListener");
        this.directIODataListeners.addElement(dl);
        this.log.out(this, "addDirectIODataListener");
    }

    public void removeDirectIODataListener(DirectIODataListener dl) {
        this.log.in(this, "removeDirectIODataListener");
        boolean re = this.directIODataListeners.removeElement(dl);
        this.log.out(this, "removeDirectIODataListener");
    }

    protected void fireDirectIODataEvent(int cmd, byte[] buf) {
        this.log.in(this, "fireDirectIODataEvent: " + cmd);
        Enumeration e = this.deviceErrorListeners.elements();
        while (e.hasMoreElements()) {
            DirectIODataListener listener = (DirectIODataListener)e.nextElement();
            listener.onDirectIOData(cmd, buf);
        }
        this.log.out(this, "fireDirectIODataEvent");
    }

    protected void parseMessages(byte[] inBuf, byte endChar, boolean bUseBCC) {
        for (int i = 0; i < inBuf.length; ++i) {
            boolean add;
            byte[] tmpBuf;
            this.bs.write(inBuf[i]);
            if (this.bNeedBCC) {
                this.bNeedBCC = false;
                tmpBuf = this.bs.toByteArray();
                add = this.msgList.add(tmpBuf);
                this.bs.reset();
                continue;
            }
            if (inBuf[i] != endChar) continue;
            if (bUseBCC) {
                this.bNeedBCC = true;
                continue;
            }
            tmpBuf = this.bs.toByteArray();
            add = this.msgList.add(tmpBuf);
            this.bs.reset();
        }
    }

    protected void parseMessages(byte[] inBuf, byte endChar) {
        this.parseMessages(inBuf, endChar, false);
    }

    protected void concatUSBMessages(byte[] inBuf, boolean bEOD) {
        for (int i = 0; i < inBuf.length; ++i) {
            this.bs.write(inBuf[i]);
        }
        if (bEOD) {
            byte[] tmpBuf = this.bs.toByteArray();
            boolean add = this.msgList.add(tmpBuf);
            this.bs.reset();
        }
    }

    protected char blockCheckCharacter(String message) {
        char bcc = '\u0000';
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            bcc = (char)(bcc ^ message.charAt(i));
        }
        return bcc;
    }

    public boolean hasStatisticsReporting() {
        return false;
    }

    public void onDataReceived(byte[] inBuf, int len) {
    }

    public void onDeviceAdded() {
    }

    public void onDeviceReattached() {
    }

    public void onDeviceRemoved() {
    }

    public Hashtable getStatistics() throws DLSException {
        throw new DLSException(-2147483642, "getStatistics not supported for this device.");
    }

    public Hashtable returnStatistics() throws DLSException {
        throw new DLSException(-2147483642, "getStatistics not supported for this device.");
    }
}

