/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.interpretation.DLSDevice;
import com.dls.jpos.interpretation.ItemReceivedListener;
import com.dls.jpos.interpretation.LabelReceivedListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import jpos.JposException;
import jpos.ScannerConst;

public abstract class DLSScanner
extends DLSDevice
implements ScannerConst {
    public static final int ACK = 6;
    public static final int NAK = 21;
    public static final int CAN = 24;
    public static final int BEL = 7;
    public static final int UNKWN = 239;
    public static final int NRESP = 255;
    public int nRecordTimeout;
    protected int nResponse;
    protected DLSScannerConfig scannerConfig;
    protected Vector labelReceivedListeners;
    protected Vector itemReceivedListeners;
    protected boolean bSendCookedData;
    protected boolean bConvertBCDtoASCII;

    public DLSScanner() {
        this.nRecordTimeout = this.nTimeout;
        this.nResponse = 0;
        this.scannerConfig = null;
        this.labelReceivedListeners = new Vector();
        this.itemReceivedListeners = new Vector();
        this.bSendCookedData = false;
        this.bConvertBCDtoASCII = true;
    }

    public void open(String strLogicalName) throws DLSException {
        super.open(strLogicalName);
        this.scannerConfig = new DLSScannerConfig();
        this.scannerConfig.loadConfiguration(strLogicalName);
    }

    public void claim(long lTimeout) throws DLSException {
        this.log.in(this, "Scanner claim");
        super.claim(lTimeout);
        DLSProperties options = DLSProperties.getInstance();
        if (options.get("com.dls.jpos.interpretation.autoLoadConfig", true)) {
            this.updateConfiguration();
            this.reportConfiguration();
        }
        this.log.out(this, "Scanner claim");
    }

    public abstract void enableBeep() throws DLSException;

    public abstract void disableBeep() throws DLSException;

    public abstract void updateConfiguration() throws DLSException;

    public abstract DLSScannerConfig reportConfiguration() throws DLSException;

    public abstract int sendRecord(String var1);

    public abstract void setFirmwareBaudRate();

    public abstract void restoreBaudRate();

    public DLSCConfig getConfiguration() {
        return this.scannerConfig;
    }

    public boolean getCanCompareFirmwareVersion() {
        if (this.scannerConfig == null) {
            return false;
        }
        return this.scannerConfig.getCanCompareFirmwareVersion();
    }

    public boolean getDeleteImageFileAfterRead() throws JposException {
        return this.scannerConfig.getDeleteImageFileAfterRead();
    }

    public void setDeleteImageFileAfterRead(boolean bDeleteAfterImageFileRead) {
        this.log.in(this, "setDeleteImageFileAfterRead: " + bDeleteAfterImageFileRead);
        this.scannerConfig.setDeleteImageFileAfterRead(bDeleteAfterImageFileRead);
        this.log.out(this, "setDeleteAfterImageFileRead");
    }

    public boolean getCanUpdateFirmware() {
        if (this.scannerConfig == null) {
            return false;
        }
        return this.scannerConfig.getCanUpdateFirmware();
    }

    protected byte[] extractBarcodeLabel(byte[] inBuf, int offset) {
        int start = 1;
        String labelIDType = this.deviceInfo.getDecodingType();
        if (labelIDType.contains("standard")) {
            switch (inBuf[offset]) {
                case 66: 
                case 82: {
                    start = 2;
                    break;
                }
                case 70: {
                    if (inBuf[offset + 1] != 70) break;
                    start = 2;
                    break;
                }
                case 65: {
                    if (inBuf[offset + 1] != 122) break;
                    start = 2;
                    break;
                }
                case 68: {
                    if (inBuf[offset + 1] != 109) break;
                    start = 2;
                    break;
                }
                case 77: {
                    if (inBuf[offset + 1] != 67) break;
                    start = 2;
                    break;
                }
                case 81: {
                    if (inBuf[offset + 1] != 82) break;
                    start = 2;
                    break;
                }
                case 36: {
                    if (inBuf[offset + 1] != 81) break;
                    start = 2;
                    break;
                }
                case 109: {
                    if (inBuf[offset + 1] != 80) break;
                    start = 2;
                }
            }
        }
        if (labelIDType.contains("warhol") && inBuf[offset] == 36 && inBuf[offset + 1] == 80) {
            start = 2;
        }
        byte[] buf = new byte[inBuf.length - 1 - (start + offset)];
        System.arraycopy(inBuf, start + offset, buf, 0, inBuf.length - (1 + start + offset));
        return buf;
    }

    protected int extractBarcodeType(byte b1, byte b2) {
        int nType = 0;
        String labelIDType = this.deviceInfo.getDecodingType();
        if (labelIDType.contains("standard")) {
            this.log.log(this, "standard");
            switch (b1) {
                case 65: {
                    if (b2 == 122) {
                        nType = 206;
                        this.log.log(this, "bar code type = SCAN_SDT_AZTEC");
                        break;
                    }
                    nType = 101;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCA");
                    break;
                }
                case 68: {
                    if (b2 != 109) break;
                    nType = 203;
                    this.log.log(this, "bar code type = SCAN_SDT_DATAMATRIX");
                    break;
                }
                case 69: {
                    nType = 102;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCE");
                    break;
                }
                case 70: {
                    if (b2 == 70) {
                        nType = 103;
                        this.log.log(this, "bar code type = SCAN_SDT_EAN8");
                        break;
                    }
                    nType = 104;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN13");
                    break;
                }
                case 77: {
                    if (b2 != 67) break;
                    nType = 202;
                    this.log.log(this, "bar code type = SCAN_SDT_MAXICODE");
                    break;
                }
                case 81: {
                    if (b2 != 82) break;
                    nType = 204;
                    this.log.log(this, "bar code type = SCAN_SDT_QRCODE");
                    break;
                }
                case 36: {
                    if (b2 != 81) break;
                    nType = 205;
                    this.log.log(this, "bar code type = SCAN_SDT_UQRCODE");
                    break;
                }
                case 82: {
                    if (b2 == 52) {
                        nType = 131;
                        this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR");
                        break;
                    }
                    if (b2 == 88) {
                        nType = 132;
                        this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR_E");
                        break;
                    }
                    if (b2 != 76) break;
                    nType = 131;
                    this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR");
                    break;
                }
                case 42: {
                    nType = 108;
                    this.log.log(this, "bar code type = SCAN_SDT_Code39");
                    break;
                }
                case 37: {
                    nType = 107;
                    this.log.log(this, "bar code type = SCAN_SDT_Codabar");
                    break;
                }
                case 38: {
                    nType = 109;
                    this.log.log(this, "bar code type = SCAN_SDT_Code93");
                    break;
                }
                case 35: {
                    nType = 110;
                    this.log.log(this, "bar code type = SCAN_SDT_Code128");
                    break;
                }
                case 107: {
                    nType = 120;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN128");
                    break;
                }
                case 80: {
                    nType = 201;
                    this.log.log(this, "bar code type = SCAN_SDT_PDF417");
                    break;
                }
                case 109: {
                    if (b2 != 80) break;
                    nType = 207;
                    this.log.log(this, "bar code type = SCAN_SDT_UPDF417");
                    break;
                }
                case 105: {
                    nType = 106;
                    this.log.log(this, "bar code type = SCAN_SDT_ITF");
                }
            }
        }
        if (labelIDType.contains("AIM")) {
            this.log.log(this, "AIM");
            switch (b1) {
                case 122: {
                    nType = 206;
                    this.log.log(this, "bar code type = SCAN_SDT_AZTEC");
                    break;
                }
                case 100: {
                    nType = 203;
                    this.log.log(this, "bar code type = SCAN_SDT_DATAMATRIX");
                    break;
                }
                case 69: {
                    nType = 102;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCE");
                    break;
                }
                case 99: {
                    if (b2 == 70) {
                        nType = 103;
                        this.log.log(this, "bar code type = SCAN_SDT_EAN8");
                        break;
                    }
                    nType = 104;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN13");
                    break;
                }
                case 85: {
                    nType = 202;
                    this.log.log(this, "bar code type = SCAN_SDT_MAXICODE");
                    break;
                }
                case 81: {
                    nType = 204;
                    this.log.log(this, "bar code type = SCAN_SDT_QRCODE");
                    break;
                }
                case 36: {
                    if (b2 != 81) break;
                    nType = 205;
                    this.log.log(this, "bar code type = SCAN_SDT_UQRCODE");
                    break;
                }
                case 101: {
                    if (b2 == 52) {
                        nType = 131;
                        this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR");
                        break;
                    }
                    if (b2 == 88) {
                        nType = 132;
                        this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR_E");
                        break;
                    }
                    if (b2 != 76) break;
                    nType = 131;
                    this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR");
                    break;
                }
                case 65: {
                    nType = 108;
                    this.log.log(this, "bar code type = SCAN_SDT_Code39");
                    break;
                }
                case 70: {
                    nType = 107;
                    this.log.log(this, "bar code type = SCAN_SDT_Codabar");
                    break;
                }
                case 71: {
                    nType = 109;
                    this.log.log(this, "bar code type = SCAN_SDT_Code93");
                    break;
                }
                case 67: {
                    if (b2 == 48) {
                        nType = 110;
                        this.log.log(this, "bar code type = SCAN_SDT_Code128");
                        break;
                    }
                    if (b2 == 49) {
                        nType = 120;
                        this.log.log(this, "bar code type = SCAN_SDT_EAN128 with FN char in first position");
                        break;
                    }
                    if (b2 != 50) break;
                    nType = 120;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN128 with FN char in second position");
                    break;
                }
                case 107: {
                    nType = 120;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN128");
                    break;
                }
                case 80: {
                    nType = 201;
                    this.log.log(this, "bar code type = SCAN_SDT_PDF417");
                    break;
                }
                case 76: {
                    if (b2 != 80) break;
                    nType = 207;
                    this.log.log(this, "bar code type = SCAN_SDT_UPDF417");
                    break;
                }
                case 73: {
                    nType = 106;
                    this.log.log(this, "bar code type = SCAN_SDT_ITF");
                }
            }
        }
        if (labelIDType.contains("warhol")) {
            this.log.log(this, "warhol");
            switch (b1) {
                case 67: {
                    nType = 101;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCA");
                    break;
                }
                case 70: 
                case 71: 
                case 81: {
                    nType = 111;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCA_S");
                    break;
                }
                case 68: {
                    nType = 102;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCE");
                    break;
                }
                case 69: 
                case 72: 
                case 73: {
                    nType = 112;
                    this.log.log(this, "bar code type = SCAN_SDT_UPCE_S");
                    break;
                }
                case 65: {
                    nType = 103;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN8");
                    break;
                }
                case 42: 
                case 74: 
                case 75: {
                    nType = 118;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN8_S");
                    break;
                }
                case 66: {
                    nType = 104;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN13");
                    break;
                }
                case 35: 
                case 76: 
                case 77: {
                    nType = 119;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN13_S");
                    break;
                }
                case 107: {
                    nType = 120;
                    this.log.log(this, "bar code type = SCAN_SDT_EAN128");
                    break;
                }
                case 117: {
                    nType = 131;
                    this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR");
                    break;
                }
                case 116: {
                    nType = 132;
                    this.log.log(this, "bar code type = SCAN_SDT_GS1DATABAR_E");
                    break;
                }
                case 86: {
                    nType = 108;
                    this.log.log(this, "bar code type = SCAN_SDT_Code39");
                    break;
                }
                case 82: {
                    nType = 107;
                    this.log.log(this, "bar code type = SCAN_SDT_Codabar");
                    break;
                }
                case 85: {
                    nType = 109;
                    this.log.log(this, "bar code type = SCAN_SDT_Code93");
                    break;
                }
                case 84: {
                    nType = 110;
                    this.log.log(this, "bar code type = SCAN_SDT_Code128");
                    break;
                }
                case 114: {
                    nType = 201;
                    this.log.log(this, "bar code type = SCAN_SDT_PDF417");
                    break;
                }
                case 56: {
                    nType = 207;
                    this.log.log(this, "bar code type = SCAN_SDT_UPDF417");
                    break;
                }
                case 78: {
                    nType = 106;
                    this.log.log(this, "bar code type = SCAN_SDT_ITF");
                    break;
                }
                case 87: {
                    nType = 105;
                    this.log.log(this, "bar code type = SCAN_SDT_TF");
                    break;
                }
                case 120: {
                    nType = 202;
                    this.log.log(this, "bar code type = SCAN_SDT_MAXICODE");
                    break;
                }
                case 119: {
                    nType = 203;
                    this.log.log(this, "bar code type = SCAN_SDT_DATAMATRIX");
                    break;
                }
                case 33: {
                    nType = 206;
                    this.log.log(this, "bar code type = SCAN_SDT_AZTEC");
                    break;
                }
                case 121: {
                    nType = 204;
                    this.log.log(this, "bar code type = SCAN_SDT_QRCODE");
                    break;
                }
                case 36: {
                    switch (b2) {
                        case 81: {
                            nType = 205;
                            this.log.log(this, "bar code type = SCAN_SDT_UQRCODE");
                        }
                    }
                }
            }
        }
        return nType;
    }

    public void addLabelReceivedListener(LabelReceivedListener drl) {
        this.log.in(this, "addLabelReceivedListener");
        this.labelReceivedListeners.addElement(drl);
        this.log.out(this, "addLabelReceivedListener");
    }

    public void removeLabelReceivedListener(LabelReceivedListener drl) {
        this.log.in(this, "removeLabelReceivedListener");
        this.labelReceivedListeners.removeElement(drl);
        this.log.out(this, "removeLabelReceivedListener");
    }

    public void addItemReceivedListener(ItemReceivedListener drl) {
        this.log.in(this, "addLabelReceivedListener");
        this.itemReceivedListeners.addElement(drl);
        this.log.out(this, "addLabelReceivedListener");
    }

    public void removeItemReceivedListener(ItemReceivedListener drl) {
        this.log.in(this, "removeLabelReceivedListener");
        this.itemReceivedListeners.removeElement(drl);
        this.log.out(this, "removeLabelReceivedListener");
    }

    protected void fireLabelReceivedEvent(byte[] rawLabel, byte[] decodeLabel, int nType) {
        byte[] decodeLabelData;
        byte[] rawLabelData;
        this.log.in(this, "fireLabelReceivedEvent");
        byte prefix = this.deviceInfo.getDataPrefix();
        byte suffix = this.deviceInfo.getDataSuffix();
        if (prefix != 0 && suffix != 0) {
            rawLabelData = new byte[rawLabel.length + 2];
            decodeLabelData = new byte[decodeLabel.length + 2];
            System.arraycopy(rawLabel, 0, rawLabelData, 1, rawLabel.length);
            System.arraycopy(decodeLabel, 0, decodeLabelData, 1, decodeLabel.length);
            rawLabelData[0] = prefix;
            decodeLabelData[0] = prefix;
            rawLabelData[rawLabel.length + 1] = suffix;
            decodeLabelData[decodeLabel.length + 1] = suffix;
        } else if (prefix != 0 || suffix != 0) {
            rawLabelData = new byte[rawLabel.length + 1];
            decodeLabelData = new byte[decodeLabel.length + 1];
            if (prefix != 0) {
                System.arraycopy(rawLabel, 0, rawLabelData, 1, rawLabel.length);
                System.arraycopy(decodeLabel, 0, decodeLabelData, 1, decodeLabel.length);
                rawLabelData[0] = prefix;
                decodeLabelData[0] = prefix;
            } else {
                System.arraycopy(rawLabel, 0, rawLabelData, 0, rawLabel.length);
                System.arraycopy(decodeLabel, 0, decodeLabelData, 0, decodeLabel.length);
                rawLabelData[rawLabel.length] = suffix;
                decodeLabelData[decodeLabel.length] = suffix;
            }
        } else {
            rawLabelData = new byte[rawLabel.length];
            decodeLabelData = new byte[decodeLabel.length];
            System.arraycopy(rawLabel, 0, rawLabelData, 0, rawLabel.length);
            System.arraycopy(decodeLabel, 0, decodeLabelData, 0, decodeLabel.length);
        }
        Enumeration e = this.labelReceivedListeners.elements();
        while (e.hasMoreElements()) {
            LabelReceivedListener listener = (LabelReceivedListener)e.nextElement();
            listener.onLabelReceived(rawLabelData, decodeLabelData, nType);
        }
        this.log.out(this, "fireLabelReceivedEvent");
    }

    protected void fireItemReceivedEvent(byte[] rawItemData) {
        this.log.in(this, "fireItemReceivedEvent");
        Enumeration e = this.itemReceivedListeners.elements();
        while (e.hasMoreElements()) {
            ItemReceivedListener listener = (ItemReceivedListener)e.nextElement();
            listener.onItemReceived(rawItemData);
        }
        this.log.out(this, "fireItemReceivedEvent");
    }

    protected String[] splitMessage(byte[] inBuf) {
        String str = "";
        this.parseMessages(inBuf, (byte)3);
        Iterator it = this.msgList.iterator();
        while (it.hasNext()) {
            byte[] buf = (byte[])it.next();
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(buf[i] == 3 ? 44 : buf[i]);
                if (buf[i] < 32 && buf[i] > 126) continue;
                str = str + (char)buf[i];
            }
        }
        this.bs.reset();
        this.msgList.clear();
        return str.split(",");
    }

    protected void logHealthCheck(byte[] sohBuf) throws DLSException {
        String str = "";
        String strDevice = "";
        String strResp = "";
        for (int i = 0; i < sohBuf.length; ++i) {
            if (sohBuf[i] != 2) continue;
            ++i;
            str = "";
            while (sohBuf[i] != 3) {
                str = str + (char)sohBuf[i];
                ++i;
            }
            if (str.length() <= 1) continue;
            switch (str.charAt(0)) {
                case 'm': {
                    this.log.trace(this, " ** CheckHealth ** : motor=" + str.substring(1));
                    strDevice = "motor";
                    break;
                }
                case 'h': {
                    this.log.trace(this, " ** CheckHealth ** : H laser=" + str.substring(1));
                    strDevice = "Horizontal Laser";
                    break;
                }
                case 'v': {
                    this.log.trace(this, " ** CheckHealth ** : V laser=" + str.substring(1));
                    strDevice = "Vertical Laser";
                    break;
                }
                case 's': {
                    this.log.trace(this, " ** CheckHealth ** : scale=" + str.substring(1));
                    strDevice = "Scale";
                    break;
                }
                case 'd': {
                    this.log.trace(this, " ** CheckHealth ** : display=" + str.substring(1));
                    strDevice = "Display";
                    break;
                }
                case 'e': {
                    this.log.trace(this, " ** CheckHealth ** : EAS=" + str.substring(1));
                    strDevice = "EAS";
                    break;
                }
                case 'c': {
                    this.log.trace(this, " ** CheckHealth ** : camera=" + str.substring(1));
                    strDevice = "Camera";
                    break;
                }
                default: {
                    this.log.trace(this, " ** CheckHealth ** : unknown=" + str.substring(1));
                }
            }
            strResp = str.substring(1);
            if (!strResp.equals("FAIL")) continue;
            this.log.error(this, "Device error in check health: " + strDevice);
            throw new DLSException(-2147483639, "Scanner: " + strDevice);
        }
    }
}

