/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSObjectFactory;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.interpretation.DLSScale;
import com.dls.jpos.interpretation.DeviceErrorStatusListener;
import com.dls.jpos.interpretation.WeightReceivedListener;
import com.dls.jpos.service.DLSBaseService;
import com.dls.jpos.service.ScannerScaleAgent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import jpos.JposException;
import jpos.ScaleConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;
import jpos.services.ScaleService113;

public class DLSScaleService
extends DLSBaseService
implements ScaleService113,
ScaleConst,
WeightReceivedListener,
DeviceErrorStatusListener {
    protected static final int CMD_PENDING = -1;
    protected static final int CMD_ABORT = -2;
    protected static final int CMD_COMPLETE = -3;
    protected static final int CMD_MOTION = -4;
    protected static final int CMD_OVERWEIGHT = -5;
    protected static final int CMD_ZERO = -6;
    protected static final int CMD_AT_ZERO = -7;
    protected static final int CMD_TIMEOUT = -8;
    protected static final int CMD_UNDERZERO = -9;
    protected static final int SCALE_IN_MOTION = 112;
    protected static final int SCALE_NEEDS_ZEROING = 113;
    protected static final int SCALE_AT_ZERO = 114;
    protected static final int SCALE_OVERWEIGHT = 201;
    protected static final int SCALE_UNDERZERO = 202;
    protected static final int SCALE_READ_ERROR = 1;
    protected static final int MAXIMUM_READ_TIMEOUT = 5000;
    protected static final int DEFAULT_READ_TIMEOUT = 1000;
    protected WeightData currentWeightData = new WeightData();
    protected DLSScale scale = null;
    protected boolean bAsyncMode = false;
    protected boolean bAutoDisable = false;
    protected int nMaxWeight = 30000;
    protected int nWeightUnit = 4;
    protected int nTareWeight = 0;
    protected long lUnitPrice = 0L;
    protected boolean bDataEventEnabled = false;
    protected boolean bMetricMode = false;
    protected Object scaleResp = new Object();
    protected boolean bExceptionOnMotion = false;
    protected boolean bIsZeroValid = false;
    protected boolean bWMIEnabled = false;
    protected boolean bMBeansEnabled = false;
    protected ScannerScaleAgent agent;

    public void open(String logicalName, EventCallbacks cb) throws JposException {
        this.log.in(this, "open: " + logicalName);
        super.open(logicalName, cb);
        try {
            DLSProperties options = DLSProperties.getInstance();
            this.bExceptionOnMotion = options.get("com.dls.jpos.service.ScaleService.ThrowExceptionOnScaleMotion", false);
            this.device = DLSObjectFactory.createScale(logicalName);
            this.scale = (DLSScale)this.device;
            this.device.open(logicalName);
            this.bAsyncMode = false;
            this.bDataEventEnabled = false;
            DLSScaleConfig config = (DLSScaleConfig)this.device.getConfiguration();
            if (config != null) {
                if (config.getMetricWeightMode()) {
                    this.nMaxWeight = config.getFiveDigitWeight() ? 15000 : 1500;
                    this.nWeightUnit = 2;
                    this.bMetricMode = true;
                } else {
                    this.nMaxWeight = config.getFiveDigitWeight() ? 30000 : 3000;
                    this.nWeightUnit = 4;
                    this.bMetricMode = false;
                }
            }
        }
        catch (DLSException e) {
            throw new JposException(111, e.getMessage());
        }
        this.log.out(this, "open");
    }

    public void claim(int lTimeout) throws JposException {
        this.log.in(this, "ScaleService claim");
        String[] temp = new String[]{""};
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        super.claim(lTimeout);
        this.scale.addWeightReceivedListener(this);
        this.scale.addDeviceStatusListener(this);
        DLSProperties options = DLSProperties.getInstance();
        DLSCConfig dConfig = this.scale.getConfiguration();
        this.bWMIEnabled = dConfig.getOptionAsBoolean("WMIEnabled");
        this.bMBeansEnabled = dConfig.getOptionAsBoolean("MBeansEnabled");
        boolean bCanAcceptStats = dConfig.getOptionAsBoolean("canAcceptStatisticsCmd");
        if (this.bWMIEnabled && bCanAcceptStats) {
            boolean success;
            this.setDeviceEnabled(true);
            super.retrieveScaleStatistics(temp);
            this.hTable.put(DLS_S_SCALE_CAP_DISP_TEXT, this.getCapDisplayText() ? "True" : "False");
            this.hTable.put(DLS_S_SCALE_CAP_PRICE_CALC, this.getCapPriceCalculating() ? "True" : "False");
            this.hTable.put(DLS_S_SCALE_CAP_TARE_WT, this.getCapTareWeight() ? "True" : "False");
            this.hTable.put(DLS_S_SCALE_CAP_ZERO, this.getCapZeroScale() ? "True" : "False");
            this.hTable.put(DLS_S_SCALE_STAT_UPDATE, this.getCapStatusUpdate() ? "True" : "False");
            String scaleContents = new String();
            BufferedWriter output = null;
            String sScannerTempFile = "scanner_temp.txt";
            String sScaleTempfile = "scale_temp.txt";
            if (this.log.strLogFileDir != null) {
                sScannerTempFile = this.log.strLogFileDir + sScannerTempFile;
                sScaleTempfile = this.log.strLogFileDir + sScaleTempfile;
            }
            File scannerTempfile = new File(sScannerTempFile);
            File scaleTempfile = new File(sScaleTempfile);
            if (scannerTempfile.exists()) {
                try {
                    String str;
                    BufferedReader in = new BufferedReader(new FileReader(sScannerTempFile));
                    while ((str = in.readLine()) != null) {
                        String[] result = str.split("=");
                        if (result.length == 1) {
                            this.hTable.put(result[0], "NA");
                            continue;
                        }
                        this.hTable.put(result[0], result[1]);
                    }
                    in.close();
                }
                catch (IOException ex) {
                    this.log.error(this, "IOException: " + ex.getMessage());
                }
            }
            try {
                Enumeration e = this.hTable.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = (String)this.hTable.get(key);
                    scaleContents = scaleContents + key + "=" + value + "\n";
                }
                output = new BufferedWriter(new FileWriter(scaleTempfile));
                output.write(scaleContents);
                ((Writer)output).close();
            }
            catch (IOException ex) {
                this.log.error(this, "IOException: " + ex.getMessage());
            }
            if (scannerTempfile.exists()) {
                this.lWMI.CreateWMIScaleFile(this.hTable);
            }
            if (!(success = new File(sScannerTempFile).delete())) {
                this.log.error(this, "Deletion failed: scanner_temp.txt");
            }
            this.setDeviceEnabled(false);
        }
        if (this.bMBeansEnabled & bCanAcceptStats) {
            this.agent = new ScannerScaleAgent(this.hTable, "Scale");
        }
        this.log.out(this, "ScaleService claim");
    }

    public void release() throws JposException {
        this.log.in(this, "release");
        this.scale.removeWeightReceivedListener(this);
        this.scale.removeDeviceStatusListener(this);
        if (this.bWMIEnabled) {
            this.agent.UnregisterAgent();
        }
        super.release();
        this.log.out(this, "release");
    }

    public boolean getCapStatusUpdate() throws JposException {
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        return this.scale.canStatusUpdate();
    }

    public boolean getCapDisplay() throws JposException {
        this.log.in(this, "getCapDisplay");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapDisplay");
        return false;
    }

    public int getMaximumWeight() throws JposException {
        this.log.in(this, "getMaximumWeight: " + this.nMaxWeight);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getMaximumWeight");
        return this.nMaxWeight;
    }

    public int getWeightUnit() throws JposException {
        this.log.in(this, "getWeightUnit: " + this.nWeightUnit);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getWeightUnit");
        return this.nWeightUnit;
    }

    public int getScaleLiveWeight() throws JposException {
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        return this.scale.getLiveWeight();
    }

    public int getStatusNotify() throws JposException {
        this.log.in(this, "getStatusNotify");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "setStatusNotify");
        return this.scale.getStatusNotify();
    }

    public void setStatusNotify(int nValue) throws JposException {
        this.log.in(this, "setStatusNotify: " + nValue);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getCapStatusUpdate()) {
            throw new JposException(106, "Capability not available");
        }
        if (this.getDeviceEnabled()) {
            throw new JposException(106, "Device is enabled");
        }
        this.scale.setStatusNotify(nValue);
        this.log.out(this, "setStatusNotify");
    }

    protected void getWeight() throws JposException {
        this.log.in(this, "getWeight");
        try {
            if (this.bMetricMode) {
                this.scale.readMetricWeight();
            } else {
                this.scale.readEnglishWeight();
            }
        }
        catch (DLSException e) {
            this.log.error(this, e.getMessage());
            throw new JposException(111, e.getMessage());
        }
        this.log.out(this, "getWeight");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getWeightAsync(int nTimeout) throws JposException {
        this.log.in(this, "getWeightAsync");
        try {
            WeightData weightData = this.currentWeightData;
            synchronized (weightData) {
                long currTime = System.currentTimeMillis();
                if (this.currentWeightData.nEndTime > currTime && this.currentWeightData.nState == -1) {
                    throw new JposException(113, "Read command pending");
                }
                this.currentWeightData.nEndTime = nTimeout > 0 ? currTime + (long)nTimeout : 0L;
                this.currentWeightData.nState = -1;
            }
            this.getWeight();
        }
        catch (JposException jpe) {
            this.log.error(this, "getWeightAsync: " + jpe.getMessage());
            throw jpe;
        }
        this.log.out(this, "getWeightAsync");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getWeightSync(int[] weightData, int nTimeout) throws JposException {
        this.log.in(this, "getWeightSync");
        WeightData weightData2 = this.currentWeightData;
        synchronized (weightData2) {
            int nWait = 5000;
            if (nTimeout == 0) {
                this.currentWeightData.bRetry = false;
                nWait = 1000;
            } else {
                this.currentWeightData.bRetry = true;
                if (nTimeout > 0 && nTimeout < 5000) {
                    nWait = nTimeout;
                }
            }
            this.currentWeightData.nState = -1;
            this.getWeight();
            try {
                this.currentWeightData.wait(nWait);
            }
            catch (InterruptedException e) {
                this.log.error(this, e.getMessage());
            }
            this.currentWeightData.bSendPending = false;
            weightData[0] = this.currentWeightData.nWeight;
            if (this.currentWeightData.nState != -3) {
                weightData[0] = 0;
                switch (this.currentWeightData.nState) {
                    case -1: {
                        this.currentWeightData.nState = -3;
                        throw new JposException(112, "Timeout on scale read");
                    }
                    case -3: {
                        break;
                    }
                    case -2: {
                        break;
                    }
                    case -6: {
                        this.log.log(this, "Scale needs zeroing - throwing exception: 113");
                        throw new JposException(113, "Scale needs zeroing");
                    }
                    case -7: {
                        this.log.log(this, "Scale at zero - throwing exception: 114");
                        throw new JposException(114, "Scale at zero");
                    }
                    case -4: {
                        this.log.log(this, "Scale in motion - throwing excepiton: 112");
                        throw new JposException(112, "Scale in motion");
                    }
                    case -5: {
                        this.log.log(this, "Scale over capacity - throwing exception: 201");
                        throw new JposException(201, "Scale over capacity");
                    }
                    case -9: {
                        this.log.log(this, "Scale under zero - throwing exception: 202");
                        throw new JposException(202, "Scale undere zero ");
                    }
                    default: {
                        throw new JposException(this.currentWeightData.nState, "Scale read error.");
                    }
                }
            }
        }
        this.log.out(this, "getWeightSync");
    }

    public void readWeight(int[] weightData, int timeout) throws JposException {
        this.log.in(this, "readWeight: AsyncMode=" + this.bAsyncMode);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        try {
            if (this.bAsyncMode) {
                this.getWeightAsync(timeout);
            } else {
                this.getWeightSync(weightData, timeout);
            }
        }
        catch (JposException jpe) {
            this.log.error(this, jpe.getMessage());
            throw jpe;
        }
        this.log.out(this, "readWeight: " + weightData[0]);
    }

    public boolean getCapDisplayText() throws JposException {
        this.log.in(this, "getCapDisplayText");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapDisplayText");
        return false;
    }

    public boolean getCapPriceCalculating() throws JposException {
        this.log.in(this, "getCapPriceCalculating");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getCapPriceCalculating");
        return false;
    }

    public boolean getCapTareWeight() throws JposException {
        this.log.in(this, "getCapTareWeight");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.log.out(this, "getCapTareWeight");
        return false;
    }

    public boolean getCapZeroScale() throws JposException {
        this.log.in(this, "getCapZeroScale");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.in(this, "getCapZeroScale");
        return this.scale.canZeroScale();
    }

    public boolean getAsyncMode() throws JposException {
        this.log.in(this, "getAsyncMode: " + this.bAsyncMode);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getAsyncMode");
        return this.bAsyncMode;
    }

    public void setAsyncMode(boolean asyncMode) throws JposException {
        this.log.in(this, "setAsyncMode: " + asyncMode);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.bAsyncMode = asyncMode;
        this.log.out(this, "setAsyncMode");
    }

    public boolean getAutoDisable() throws JposException {
        this.log.in(this, "getAutoDisable: " + this.bAutoDisable);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getAutoDisable");
        return this.bAutoDisable;
    }

    public void setAutoDisable(boolean autoDisable) throws JposException {
        this.log.in(this, "setAutoDisable: " + autoDisable);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.bAutoDisable = autoDisable;
        this.log.out(this, "setAutoDisable");
    }

    public int getDataCount() throws JposException {
        this.log.in(this, "getDataCount: " + (this.currentWeightData.bSendPending ? "1" : "0"));
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getDataCount");
        return this.currentWeightData.bSendPending ? 1 : 0;
    }

    public boolean getDataEventEnabled() throws JposException {
        this.log.in(this, "getDataEventEnabled: " + this.bDataEventEnabled);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getDataEventEnabled");
        return this.bDataEventEnabled;
    }

    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        this.log.in(this, "setDataEventEnabled: " + dataEventEnabled);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.bDataEventEnabled = dataEventEnabled;
        if (dataEventEnabled && this.getClaimed() && !this.getFreezeEvents()) {
            this.sendDataEvent();
        }
        this.log.out(this, "setDataEventEnabled");
    }

    public int getMaxDisplayTextChars() throws JposException {
        this.log.in(this, "getMaxDisplayTextChars");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        this.log.out(this, "getMaxDisplayTextChars");
        return 0;
    }

    public long getSalesPrice() throws JposException {
        this.log.in(this, "getSalesPrice");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.log.out(this, "getSalesPrice");
        return 0L;
    }

    public int getTareWeight() throws JposException {
        this.log.in(this, "getTareWeight: " + this.nTareWeight);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.log.out(this, "getTareWeight");
        return this.nTareWeight;
    }

    public void setTareWeight(int tareWeight) throws JposException {
        this.log.in(this, "setTareWeight: " + tareWeight);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.nTareWeight = tareWeight;
        this.log.out(this, "setTareWeight");
    }

    public long getUnitPrice() throws JposException {
        this.log.in(this, "getUnitPrice: " + this.lUnitPrice);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.log.out(this, "getUnitPrice");
        return this.lUnitPrice;
    }

    public void setUnitPrice(long unitPrice) throws JposException {
        this.log.in(this, "setUnitPrice: " + unitPrice);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.lUnitPrice = unitPrice;
        this.log.out(this, "setUnitPrice");
    }

    public boolean getZeroValid() throws JposException {
        return this.scale.getZeroValid();
    }

    public void setZeroValid(boolean zeroValid) throws JposException {
        this.scale.setZeroValid(zeroValid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInput() throws JposException {
        this.log.in(this, "clearInput");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        WeightData weightData = this.currentWeightData;
        synchronized (weightData) {
            this.currentWeightData.nState = -2;
            this.currentWeightData.bSendPending = false;
            this.currentWeightData.nEndTime = 0L;
            this.currentWeightData.notifyAll();
        }
        this.log.out(this, "clearInput");
    }

    public void displayText(String data) throws JposException {
        this.log.in(this, "displayText: " + data);
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.log.out(this, "displayText");
    }

    public void zeroScale() throws JposException {
        this.log.in(this, "zeroScale");
        if (this.getState() == 1) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        if (this.scale.canZeroScale()) {
            try {
                this.scale.zeroScale();
            }
            catch (DLSException e) {
                this.log.error(this, e.getMessage());
                throw new JposException(111, e.getMessage());
            }
        } else {
            throw new JposException(106, "Zero scale not supported");
        }
        this.log.out(this, "zeroScale");
    }

    public void deleteInstance() throws JposException {
    }

    public void onDeviceStatus(int nStatusCode) {
        if (this.scale.getStatusNotify() == 2) {
            this.evtCallback.fireStatusUpdateEvent(new StatusUpdateEvent(this.evtCallback.getEventSource(), nStatusCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onDeviceError(int nErrorCode) {
        this.log.in(this, "onDeviceError: " + nErrorCode);
        WeightData weightData = this.currentWeightData;
        synchronized (weightData) {
            if (nErrorCode == -101 || nErrorCode == -117) {
                if (this.bExceptionOnMotion) {
                    this.currentWeightData.nWeight = 0;
                    this.currentWeightData.nState = nErrorCode == -101 ? -4 : -7;
                    this.currentWeightData.bSendPending = false;
                    this.currentWeightData.bRetry = false;
                    this.currentWeightData.nEndTime = 0L;
                    this.currentWeightData.notifyAll();
                } else if (this.currentWeightData.nState == -1) {
                    if (this.bAsyncMode) {
                        long currTime = System.currentTimeMillis();
                        if (this.currentWeightData.nEndTime < currTime) {
                            this.currentWeightData.nState = -8;
                            this.currentWeightData.nEndTime = 0L;
                            return;
                        }
                    } else if (!this.currentWeightData.bRetry) {
                        this.currentWeightData.nWeight = 0;
                        this.currentWeightData.bSendPending = false;
                        this.currentWeightData.nEndTime = 0L;
                        this.currentWeightData.notifyAll();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        this.log.error(this, "java.lang.Thread.sleep(100): " + ie.getMessage());
                    }
                    try {
                        this.getWeight();
                    }
                    catch (JposException jpe) {
                        this.currentWeightData.nState = 111;
                        this.currentWeightData.notifyAll();
                    }
                }
            } else {
                this.currentWeightData.nState = 111;
                switch (nErrorCode) {
                    case -100: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -100, 1, 12));
                        break;
                    }
                    case -102: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -102, 1, 12));
                        break;
                    }
                    case -103: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -103, 2, 12));
                        break;
                    }
                    case -104: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 107, -104, 2, 12));
                        break;
                    }
                    case -105: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -105, 2, 12));
                        break;
                    }
                    case -106: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -106, 1, 12));
                        break;
                    }
                    case -107: {
                        if (this.bExceptionOnMotion) {
                            this.currentWeightData.nWeight = 0;
                            this.currentWeightData.nState = -5;
                            this.currentWeightData.bSendPending = false;
                            this.currentWeightData.nEndTime = 0L;
                            break;
                        }
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 201, -107, 2, 12));
                        break;
                    }
                    case -118: {
                        if (this.bExceptionOnMotion) {
                            this.currentWeightData.nWeight = 0;
                            this.currentWeightData.nState = -5;
                            this.currentWeightData.bSendPending = false;
                            this.currentWeightData.nEndTime = 0L;
                            break;
                        }
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 202, -118, 2, 12));
                        break;
                    }
                    case -108: {
                        if (this.bExceptionOnMotion) {
                            this.currentWeightData.nWeight = 0;
                            this.currentWeightData.nState = -6;
                            this.currentWeightData.bSendPending = false;
                            this.currentWeightData.nEndTime = 0L;
                            break;
                        }
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -108, 2, 12));
                        break;
                    }
                    case -109: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -109, 2, 12));
                        break;
                    }
                    case -110: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -110, 2, 12));
                        break;
                    }
                    case -116: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 107, -116, 2, 12));
                    }
                }
                this.currentWeightData.notifyAll();
            }
        }
        this.log.out(this, "onDeviceError");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWeightReceived(int nWeight) {
        this.log.trace(this, "weight Received: " + nWeight);
        try {
            if (this.getAutoDisable()) {
                this.setDeviceEnabled(false);
            }
        }
        catch (JposException e) {
            this.log.error(this, "JposException: " + e.getMessage());
        }
        WeightData weightData = this.currentWeightData;
        synchronized (weightData) {
            long currTime;
            this.currentWeightData.nWeight = nWeight;
            this.currentWeightData.nState = -3;
            this.currentWeightData.bSendPending = true;
            this.currentWeightData.bRetry = false;
            if (this.bAsyncMode && this.currentWeightData.nEndTime > 0L && this.currentWeightData.nEndTime < (currTime = System.currentTimeMillis())) {
                this.currentWeightData.nState = -8;
            }
            this.currentWeightData.nEndTime = 0L;
            this.currentWeightData.notifyAll();
        }
        if (this.bAsyncMode && this.currentWeightData.nState == -3) {
            this.sendDataEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataEvent() {
        block5: {
            try {
                this.log.in(this, "sendDataEvent:" + this.getDataCount() + "," + this.bDataEventEnabled + "," + this.getFreezeEvents());
                if (this.getDataCount() == 0 || !this.bDataEventEnabled || this.getFreezeEvents()) break block5;
                this.bDataEventEnabled = false;
                this.log.trace(this, "Firing dataEvent");
                WeightData weightData = this.currentWeightData;
                synchronized (weightData) {
                    this.evtCallback.fireDataEvent(new DataEvent(this.evtCallback.getEventSource(), this.currentWeightData.nWeight));
                    this.currentWeightData.bSendPending = false;
                }
            }
            catch (JposException e) {
                this.log.error(this, e.getMessage());
            }
        }
        this.log.out(this, "sendDataEvent");
    }

    protected class WeightData {
        public int nWeight = 0;
        public int nState = -3;
        public boolean bSendPending = false;
        public long nEndTime = 0L;
        public boolean bRetry = false;

        protected WeightData() {
        }
    }
}

