/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSLogManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WMIService {
    public DLSLogManager log = DLSLogManager.getInstance();
    private DLSJposConst DLSconst;

    public Map CreateWMIFile(Hashtable hTable) {
        this.log.in(this, "CreateWMIFile");
        HashMap map = new HashMap();
        Set set = hTable.entrySet();
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (key == null) {
                key = "" + null;
            }
            if (val == null) {
                val = "" + null;
            }
            map.put(key, val);
        }
        this.log.out(this, "CreateWMIFile");
        return map;
    }

    public Map convertHashTableToHashMap(Hashtable hTable) {
        HashMap map = new HashMap();
        Set set = hTable.entrySet();
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (key == null) {
                key = "" + null;
            }
            if (val == null) {
                val = "" + null;
            }
            map.put(key, val);
        }
        return map;
    }

    public void CreateWMIFile(String[] lString) {
    }

    public void CreateWMIScannerFile(Hashtable wmiHTable) {
        this.log.in(this, "CreateWMIScannerFile");
        String classString = "#pragma classflags(\"forceupdate\")\n#pragma namespace (\"\\\\\\\\.\\\\Root\\\\CIMV2\")\n[\n\tDescription (\"The JPOS Scanner Class describes characteristics of Scanner devices.\"):\n\tToSubClass\n]\nclass UPOS_Scanner\n{\n\t[\nread, key,\n\t\tDescription(\"The Device ID Must be unique for each storage instance\"):\n\t\tDisableOverride ToSubClass\n\t]\n";
        String instanceString = "\ninstance of UPOS_Scanner\n{\n";
        Enumeration e = wmiHTable.keys();
        String key = (String)e.nextElement();
        classString = classString + "string " + key + ";\n";
        while (e.hasMoreElements()) {
            classString = classString + "[write (true): ToSubClass]\n";
            key = (String)e.nextElement();
            Object ob = wmiHTable.get(key);
            instanceString = instanceString + "  " + key + " = ";
            if (ob instanceof Boolean) {
                classString = classString + "boolean " + key + ";\n";
                instanceString = instanceString + ob + ";\n";
                continue;
            }
            if (ob instanceof String) {
                classString = classString + "string " + key + ";\n";
                instanceString = instanceString + "\"" + ob + "\"" + ";\n";
                continue;
            }
            if (!(ob instanceof Integer)) continue;
            classString = classString + "uint32 " + key + ";\n";
            instanceString = instanceString + ob + ";\n";
        }
        classString = classString + "};\n";
        instanceString = instanceString + "};\n";
        String sWriteFile = this.WriteMOFfile(classString, instanceString);
        boolean bCallWMI = this.CallWMI(sWriteFile);
        this.log.out(this, "CreateWMIScannerFile");
    }

    public void CreateWMIScaleFile(Hashtable wmiHTable) {
        this.log.in(this, "CreateWMIScaleFile");
        String classString = "#pragma classflags(\"forceupdate\")\n#pragma namespace (\"\\\\\\\\.\\\\Root\\\\CIMV2\")\n[\n\tDescription (\"The JPOS Scale Class describes characteristics of Scale devices.\"):\n\tToSubClass\n]\nclass UPOS_Scale\n{\n\t[\nread, key,\n\t\tDescription(\"The Device ID Must be unique for each storage instance\"):\n\t\tDisableOverride ToSubClass\n\t]\n";
        String instanceString = "\ninstance of UPOS_Scale\n{\n";
        Enumeration e = wmiHTable.keys();
        String key = (String)e.nextElement();
        classString = classString + "string " + key + ";\n";
        while (e.hasMoreElements()) {
            classString = classString + "[write (true): ToSubClass]\n";
            key = (String)e.nextElement();
            Object ob = wmiHTable.get(key);
            instanceString = instanceString + "  " + key + " = ";
            if (ob instanceof Boolean) {
                classString = classString + "boolean " + key + ";\n";
                instanceString = instanceString + ob + ";\n";
                continue;
            }
            if (ob instanceof String) {
                classString = classString + "string " + key + ";\n";
                instanceString = instanceString + "\"" + ob + "\"" + ";\n";
                continue;
            }
            if (!(ob instanceof Integer)) continue;
            classString = classString + "uint32 " + key + ";\n";
            instanceString = instanceString + ob + ";\n";
        }
        classString = classString + "};\n";
        instanceString = instanceString + "};\n";
        String sWriteFile = this.WriteMOFfile(classString, instanceString);
        boolean bCallWMI = this.CallWMI(sWriteFile);
        this.log.out(this, "CreateWMIScaleFile");
    }

    private String WriteMOFfile(String sClass, String sInstance) {
        this.log.in(this, "MOF file write");
        BufferedWriter output = null;
        String sWMIfielname = "DatalogicScanner.MOF";
        if (this.log.strLogFileDir != null) {
            sWMIfielname = this.log.strLogFileDir + sWMIfielname;
        }
        File file = new File(sWMIfielname);
        try {
            output = new BufferedWriter(new FileWriter(file));
            output.write(sClass + sInstance);
            ((Writer)output).close();
        }
        catch (IOException ex) {
            this.log.error(this, "Error creating " + file.getName() + " " + ex.getLocalizedMessage());
        }
        this.log.out(this, "MOF file has been written: " + file.getName().toString());
        return sWMIfielname;
    }

    private boolean CallWMI(String filename) {
        this.log.in(this, "Calling mofcomp.exe");
        boolean retValue = true;
        ArrayList<String> command = new ArrayList<String>();
        command.add(System.getenv("windir") + "\\system32\\Wbem\\" + "mofcomp.exe");
        command.add(filename);
        ProcessBuilder builder = new ProcessBuilder(command);
        Map<String, String> environ = builder.environment();
        try {
            String line;
            Process process = builder.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                this.log.trace(this, line);
            }
        }
        catch (IOException ex) {
            this.log.error(this, "Error starting process: " + ex.getLocalizedMessage());
            retValue = false;
        }
        File f = new File(filename);
        this.log.out(this, "Calling mofcomp.exe");
        return retValue;
    }
}

