/*
 * Decompiled with CFR 0.152.
 */
package jpos.profile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpos.profile.DefaultProfile;
import jpos.profile.Profile;
import jpos.profile.ProfileException;
import jpos.profile.ProfileFactory;
import jpos.util.XmlHelper;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesProfileFactory
implements ProfileFactory {
    private Profile profile = null;
    private DOMParser domParser = new DOMParser();
    private DefaultErrorHandler errorHandler = new DefaultErrorHandler();
    private Tracer tracer = TracerFactory.getInstance().createTracer("XercesProfileFactory");
    public static final String PROFILE_DTD_FILE_NAME = "jcl_profile.dtd";
    public static final String PROFILE_DTD_FILE_PATH = "jpos" + File.separator + "res" + File.separator;

    private Profile extractProfile(Document document) throws ProfileException {
        Element element = document.getDocumentElement();
        String string = element.getAttribute("name");
        DefaultProfile defaultProfile = new DefaultProfile(string);
        NodeList nodeList = element.getElementsByTagName("ProfileInfo");
        if (nodeList.getLength() != 1) {
            throw new ProfileException("Profile does not contain 1 ProfileInfo element");
        }
        Element element2 = (Element)nodeList.item(0);
        defaultProfile.setVersion(element2.getAttribute("version"));
        defaultProfile.setVendorName(element2.getAttribute("vendorName"));
        try {
            String string2 = element2.getAttribute("vendorUrl");
            defaultProfile.setVendorUrl(new URL(string2));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ProfileException("ProfileInfo contains an invalid vendorUrl string");
        }
        defaultProfile.setDescription(element2.getAttribute("description"));
        return defaultProfile;
    }

    Document parse(String string) throws ProfileException {
        XmlHelper xmlHelper = new XmlHelper();
        try {
            xmlHelper.setDtdFileName(PROFILE_DTD_FILE_NAME);
            xmlHelper.setDtdFilePath(PROFILE_DTD_FILE_PATH);
            xmlHelper.checkAndCreateTempDtd();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
            documentBuilder.setErrorHandler(defaultErrorHandler);
            Document document = documentBuilder.parse(new File(string));
            if (defaultErrorHandler.getErrorList().size() > 0 || defaultErrorHandler.getFatalErrorList().size() > 0) {
                String string2 = "Error while parsing XML file, set properties jpos.tracing = ON in jpos.properties file for details";
                throw new ProfileException(string2);
            }
            Document document2 = document;
            return document2;
        }
        catch (IOException iOException) {
            String string3 = "Error loading XML profile file";
            this.tracer.println(string3 + ": Exception.message = " + iOException.getMessage());
            throw new ProfileException(string3, iOException);
        }
        catch (SAXException sAXException) {
            String string4 = "Error parsing XML profile file";
            this.tracer.println(string4 + ": Exception.message = " + sAXException.getMessage());
            throw new ProfileException(string4, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string5 = "Error creating XML parser";
            this.tracer.println(string5 + ": Exception.message = " + parserConfigurationException.getMessage());
            throw new ProfileException(string5, parserConfigurationException);
        }
        finally {
            xmlHelper.removeTempDtd();
        }
    }

    Document parseSchema(String string) throws ProfileException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
            documentBuilder.setErrorHandler(defaultErrorHandler);
            Document document = documentBuilder.parse(new File(string));
            return document;
        }
        catch (IOException iOException) {
            String string2 = "Error loading XML profile file";
            this.tracer.println(string2 + ": Excpetion.message = " + iOException.getMessage());
            throw new ProfileException(string2, iOException);
        }
        catch (SAXException sAXException) {
            String string3 = "Error parsing XML profile file";
            this.tracer.println(string3 + ": Exception.message = " + sAXException.getMessage());
            throw new ProfileException(string3, sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string4 = "Error creating XML parser";
            this.tracer.println(string4 + ": Exception.message = " + parserConfigurationException.getMessage());
            throw new ProfileException(string4, parserConfigurationException);
        }
    }

    Profile load(String string) throws ProfileException {
        Document document = this.parse(string);
        return this.extractProfile(document);
    }

    public Profile createProfile(String string) throws ProfileException {
        return this.load(string);
    }

    class DefaultErrorHandler
    implements ErrorHandler {
        private List warningList = new ArrayList();
        private List errorList = new ArrayList();
        private List fatalErrorList = new ArrayList();

        DefaultErrorHandler() {
        }

        List getErrorList() {
            return this.errorList;
        }

        List getWarningList() {
            return this.warningList;
        }

        List getFatalErrorList() {
            return this.fatalErrorList;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            XercesProfileFactory.this.tracer.println("Line " + sAXParseException.getLineNumber() + ": WARNING SAXParseException.message = " + sAXParseException.getMessage());
            this.warningList.add(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            XercesProfileFactory.this.tracer.println("Line " + sAXParseException.getLineNumber() + ": ERROR SAXParseException.message = " + sAXParseException.getMessage());
            this.errorList.add(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            XercesProfileFactory.this.tracer.println("Line " + sAXParseException.getLineNumber() + ": FATALERROR SAXParseException.message = " + sAXParseException.getMessage());
            this.fatalErrorList.add(sAXParseException);
        }
    }
}

